/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Linux block emulation definitions.
 */

#ifndef _LINUX_BLOCK_H_
#define _LINUX_BLOCK_H_

/*
 * One of these structures exists for each
 * open block device.
 */
struct peropen {
	unsigned short count;		/* open count */
	unsigned short busy:1;		/* someone is opening the device */
	unsigned short want:1;		/* someone wants the device */
	int	mode;			/* open mode */
	struct	inode inode;		/* Linux inode structure */
	struct	file_operations *fops;	/* Linux file operations vector */
	int	bsize;			/* block size */
	int	bshift;			/* block shift */
	int	bmask;			/* block mask */
	unsigned size;			/* size in sectors (512 bytes) */
	fdev_t	*dev;			/* generic device structure */
	struct	peropen *next;		/* next peropen in list */
};

/*
 * One these exists for each registered driver.
 */
struct device_struct {
	struct file_operations *fops;
	const char *name;
};

extern struct device_struct blkdevs[];

#define DISK_BLOCK_SIZE		512
#define DISK_BLOCK_BITS 	9

#endif /* _LINUX_BLOCK_H_ */
