/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Initalization routines.
 */
#ifndef OSKIT
#define OSKIT
#endif

#define OSKIT_INCLUDE

#include <malloc.h>

#include <flux/fdev.h>
#include <flux/lmm.h>
#include <flux/debug.h>
#include <flux/page.h>
#include <flux/x86/pc/phys_lmm.h>

#include <linux/config.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/string.h>

#include <asm/system.h>

#if 1
#define DEBUG_MSG()	printf("%s:%d:\n", __FILE__, __LINE__);
#else
#define DEBUG_MSG()
#endif

/*
 * Set if the machine has an EISA bus.
 */
int EISA_bus = 0;

/*
 * Timing loop count.
 */
unsigned long loops_per_sec = 1;

/*
 * End of physical memory.
 */
unsigned long high_memory;

/*
 * Hard drive parameters obtained from the BIOS.
 */
struct drive_info_struct {
	char dummy[32];
} drive_info;


/*
 * Set of current structures.
 */
#if 0
struct task_struct *current_set[NR_CPUS];
#else
struct task_struct *current; 
#endif

/*
 * Forward declarations.
 */
static void calibrate_delay(void);

extern void timer_bh(void *);
extern void tqueue_bh(void *);
extern void startrtclock(void);
extern void linux_version_init(void);
extern void linux_kmem_init(void);
extern unsigned long pci_init(unsigned long, unsigned long);
extern void linux_net_emulation_init (void);
extern void device_setup(void);
extern void linux_printk(char *, ...);
extern void linux_timer_intr(void);

/*
 * Amount of contiguous memory to allocate for initialization.
 */
#define CONTIG_ALLOC	(512 * 1024)

struct task_struct ts;


/*
 * Linux initialization.
 */
void
fdev_linux_init()
{
	char *p;
	int flags;
	unsigned memory_start, memory_end;
	vm_offset_t addr, x;
	vm_size_t size;
	void *kaddr;

	current = &ts;
	linux_fdev_init_ts(&ts);

	printf("%s %d: Initializing Linux subsystem.\n", __FUNCTION__,
	       __LINE__);

	/*
	 * Initialize Linux' idea of the end of physical memory.
	 */
	high_memory = phys_mem_max;

	printf("phys_mem_max = %x\n", phys_mem_max);

#if 0
	/*
	 * Initialize Linux version.
	 */
	linux_version_init();
#endif

	/*
	 * Register the Linux clock interrupt handler.
	 */
	fdev_register_timer_handler(linux_timer_intr, HZ);

	/*
	 * Check if the machine has an EISA bus.
	 */
	if (fdev_map_phys_mem(trunc_page(0xFFFD9), PAGE_SIZE, &kaddr, 0))
		panic("linux_init: unable to map physical memory");
	p = kaddr + (0xFFFD9 & (PAGE_SIZE - 1));
	if (*p++ == 'E' && *p++ == 'I' && *p++ == 'S' && *p == 'A')
		EISA_bus = 1;

	/*
	 * Permanently allocate standard device ports.
	 */
	request_region(0x00, 0x20, "dma1");
	request_region(0x40, 0x20, "timer");
	request_region(0x70, 0x10, "rtc");
	request_region(0x80, 0x20, "dma page reg");
	request_region(0xc0, 0x20, "dma2");
	request_region(0xf0, 0x02, "fpu");
	request_region(0xf8, 0x08, "fpu");

	/*
	 * Install software interrupt handlers.
	 */
	bh_base[TIMER_BH].routine = timer_bh;
	bh_base[TIMER_BH].data = 0;
	enable_bh(TIMER_BH);
	bh_base[TQUEUE_BH].routine = tqueue_bh;
	bh_base[TQUEUE_BH].data = 0;
	enable_bh(TQUEUE_BH);
#if 0
	bh_base[NET_BH].routine = net_bh;
	bh_base[NET_BH].data = 0;
	enable_bh(NET_BH);
#endif

	/*
	 * Set loop count.
	 */
	calibrate_delay();

	/*
	 * Initialize drive info.
	 */
	if (fdev_map_phys_mem(0, PAGE_SIZE, &kaddr, 0))
		panic("%s:%d: unable to map phys memory", __FILE__, __LINE__);
	x = *((unsigned *)(kaddr + 0x104));
	addr = ((x >> 12) & 0xFFFF0) + (x & 0xFFFF);
	if (fdev_map_phys_mem(trunc_page(addr), PAGE_SIZE, (void **)&x, 0))
		panic("%s:%d: unable to map phys memory", __FILE__, __LINE__);
	memcpy(&drive_info, (void *)(x + (addr & (PAGE_SIZE - 1))), 16);
	x = *((unsigned *)(kaddr + 0x118));
	addr = ((x >> 12) & 0xFFFF0) + (x & 0xFFFF);
	if (fdev_map_phys_mem(trunc_page(addr), PAGE_SIZE, (void **)&x, 0))
		panic("%s:%d: unable to map phys memory", __FILE__, __LINE__);
	memcpy((char *)&drive_info + 16,
	       (void *)(x + (addr & (PAGE_SIZE - 1))), 16);

	DEBUG_MSG();

	lmm_dump(&malloc_lmm);

	/*
	 * Allocate contiguous memory.
	 */
	if (high_memory >= 16 * 1024 * 1024)
		memory_start = 4 * 1024 * 1024;
	else
		memory_start = high_memory - 2 * CONTIG_ALLOC;
	lmm_find_free(&malloc_lmm, &memory_start, &size, &flags);
	if (size < CONTIG_ALLOC / 2)
		panic("linux_init: unable to allocate memory");
	lmm_remove_free(&malloc_lmm, (void *)memory_start, size);
	memory_start = round_page(memory_start);
	memory_end = memory_start + size;

#ifdef CONFIG_PCI
	DEBUG_MSG();

	/*
	 * Initialize PCI bus.
	 */
	memory_start = pci_init(memory_start, memory_end);
#endif

	if (memory_start > memory_end)
		panic("linux_init: ran out of memory");

	DEBUG_MSG();

	/*
	 * Free unused memory.
	 */
	memory_start = (memory_start + PAGE_SIZE - 1) & -PAGE_SIZE;
	if (memory_start < memory_end)
		lmm_add_free(&malloc_lmm, (void *)memory_start,
			     memory_end - memory_start);

	DEBUG_MSG();

	/*
	 * Initialize devices.
	 */
	fdev_intr_disable();

	printf("%s %d: About to setup devices.\n", __FUNCTION__, __LINE__);

	device_setup();
}

/*
 * Calibrate delay loop.
 * Lifted straight from Linux.
 */
static void
calibrate_delay()
{
	int ticks;

	printk("Calibrating delay loop.. ");
	while (loops_per_sec <<= 1) {
		/* Wait for "start of" clock tick.  */
		ticks = jiffies;
		while (ticks == jiffies)
			/* nothing */;
		/* Go .. */
		ticks = jiffies;
		__delay(loops_per_sec);
		ticks = jiffies - ticks;
		if (ticks >= HZ) {
			loops_per_sec = muldiv(loops_per_sec, HZ, ticks);
			printk("ok - %lu.%02lu BogoMips\n",
			       loops_per_sec / 500000,
			       (loops_per_sec / 5000) % 100);
			return;
		}
	}
	printk("failed\n");
}





void
linux_fdev_init_ts(struct task_struct *ts) 
{
	ts->state = TASK_RUNNING;
	ts->oskit_flags = 0;
}
