/*
 * Emulate Linux IRQ management.
 */

#ifndef OSKIT
#define OSKIT
#endif

#define OSKIT_INCLUDE

#include <flux/fdev.h>
#include <flux/x86/eflags.h>
#include <flux/x86/pc/pic.h>

#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/ptrace.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/kernel_stat.h>

#if 1
#define DEBUG_MSG()	printf("%s:%d:\n", __FILE__, __LINE__);
#else
#define DEBUG_MSG()
#endif

static struct {
	void	(*func)(int, struct pt_regs *);
	int	flags;
} handlers[16];

/*
 * Virtual interrupt flag.
 */
#if 0
static volatile unsigned intr_flag = 0;
#endif

/*
 * Flag indicating an interrupt is being handled.
 */
unsigned long intr_count = 0;

/*
 * Generic Linux interrupt handler.
 */
static void
linux_intr(void *data)
{
	int irq = (int)data;
	struct pt_regs regs;

	kstat.interrupts[irq]++;
	intr_count++;

	if ((handlers[irq].flags & SA_INTERRUPT) == 0)
		linux_sti();

	(*handlers[irq].func)(irq, &regs);

	intr_count--;

#if 0	
	printf("%s %d: leaving!\n", __FUNCTION__, __LINE__);
#endif
}

/*
 * Attach a handler to an IRQ.
 */
int
request_irq(unsigned int irq, void (*handler)(int, struct pt_regs *),
	    unsigned long flags, const char *device)
{
	if (handlers[irq].func) {
		DEBUG_MSG();
		return (-LINUX_EBUSY);
	}
	handlers[irq].func = handler;
	handlers[irq].flags = flags;
	if (fdev_intr_alloc(irq, linux_intr, (void *)irq, 0)) {
		DEBUG_MSG();
		handlers[irq].func = 0;
		return (-LINUX_EBUSY);
	}
	if (!handler) {
		DEBUG_MSG();
		handlers[irq].func = 0;
		fdev_intr_free(irq);
		return (-LINUX_EINVAL);
	}
	DEBUG_MSG();
	return (0);
}

/*
 * Deallocate an irq.
 */
void
free_irq(unsigned int irq)
{
	fdev_intr_free(irq);
	handlers[irq].func = 0;
}

void
disable_irq(unsigned int irq)
{
	pic_disable_irq(irq);
}

void
enable_irq(unsigned int irq)
{
	pic_enable_irq(irq);
}

#if 1
/*
 * Emulate IF flag manipulation.
 */

void
linux_cli()
{
	if (current->oskit_flags & ~TS_IF) {
		printf("%s: something fucked up, extra flags set (%#x)!\n",
		       __FUNCTION__, current->oskit_flags);
	}		

	current->oskit_flags |= TS_IF;

	fdev_intr_disable();
}

void
linux_sti()
{
	current->oskit_flags &= ~TS_IF;
	
	if (!current->oskit_flags)
		fdev_intr_enable();
	else
		printf("%s: not reenabling interrupts!\n", __FUNCTION__);
}

unsigned
linux_save_flags()
{
	return (current->oskit_flags);
}

void
linux_restore_flags(unsigned flags)
{
	current->oskit_flags = flags;

	if (flags) { 
		fdev_intr_disable();
	} else {
		fdev_intr_enable();
	}
}
#endif
