/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Miscellaneous Linux support functions and variables.
 */

#ifndef OSKIT
#define OSKIT
#endif

#define OSKIT_INCLUDE

#include <flux/fdev.h>
#include <flux/page.h>
#include <flux/x86/base_vm.h>

#include <linux/errno.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/blk.h>
#include <linux/proc_fs.h>
#include <linux/kernel_stat.h>

#include "linux_emul.h"

int (*dispatch_scsi_info_ptr)(int ino, char *buffer, char **start,
			      off_t offset, int length, int inout) = 0;

struct kernel_stat kstat;

int
linux_to_fdev_error(int err)
{
	switch (err) {

	case 0:
		return (0);

	case -LINUX_EPERM:
		return (FDEV_BAD_OPERATION);

	case -LINUX_EIO:
		return (FDEV_IO_ERROR);

	case -LINUX_ENXIO:
		return (FDEV_NO_SUCH_DEVICE);

	case -LINUX_EACCES:
		return (FDEV_BAD_OPERATION);

	case -LINUX_EFAULT:
		return (FDEV_INVALID_PARAMETER);

	case -LINUX_EBUSY:
		return (FDEV_IO_ERROR);	/* XXX */

	case -LINUX_EINVAL:
		return (FDEV_INVALID_PARAMETER);

	case -LINUX_EROFS:
		return (FDEV_BAD_OPERATION);

	case -LINUX_EWOULDBLOCK:
		return (FDEV_IO_ERROR);	/* XXX */

	case -LINUX_ENOMEM:
		return (FDEV_MEMORY_SHORTAGE);

	default:
		printf("%s:%d: unknown code %d\n", __FILE__, __LINE__, err);
		return (FDEV_IO_ERROR);
	}
}

int
block_fsync(struct inode *inode, struct file *filp)
{
	return (0);
}

int
verify_area(int rw, const void *p, unsigned long size)
{
	return (0);	/* XXX: need an fdev interface for this?  */
}

/*
 * Print device name (in decimal, hexadecimal or symbolic) -
 * at present hexadecimal only.
 * Note: returns pointer to static data!
 */
char *
kdevname(kdev_t dev)
{
	static char buffer[32];

	sprintf(buffer, "%02x:%02x", MAJOR(dev), MINOR(dev));
	return (buffer);
}

/* RO fail safe mechanism */

static long ro_bits[MAX_BLKDEV][8];

int
is_read_only(kdev_t dev)
{
	int minor,major;

	major = MAJOR(dev);
	minor = MINOR(dev);
	if (major < 0 || major >= MAX_BLKDEV)
		return (0);
	return (ro_bits[major][minor >> 5] & (1 << (minor & 31)));
}

void
set_device_ro(kdev_t dev,int flag)
{
	int minor,major;

	major = MAJOR(dev);
	minor = MINOR(dev);
	if (major < 0 || major >= MAX_BLKDEV)
		return;
	if (flag)
		ro_bits[major][minor >> 5] |= 1 << (minor & 31);
	else
		ro_bits[major][minor >> 5] &= ~(1 << (minor & 31));
}

struct proc_dir_entry proc_scsi;
struct inode_operations proc_scsi_inode_operations;
struct proc_dir_entry proc_net;
struct inode_operations proc_net_inode_operations;

int
proc_register (struct proc_dir_entry *xxx1, struct proc_dir_entry *xxx2)
{
	return 0;
}

int
proc_unregister (struct proc_dir_entry *xxx1, int xxx2)
{
	return 0;
}

void
add_blkdev_randomness (int major)
{
}

int
dev_get_info (char *buffer, char **start, off_t offset, int length, int dummy)
{
	return 0;
}

void
do_gettimeofday(struct timeval *tv)
{
	tv->tv_sec = jiffies;	/* XXX! */
	tv->tv_usec = 0;
}

/*
 * XXX: These *really* need to be fixed
 */

unsigned long
virt_to_phys(volatile void *address)
{
	return (kvtophys((unsigned long)address));
}

void *
phys_to_virt(unsigned long address)
{
	return ((void *)phystokv(address));
}
