/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Linux scheduler support.
 *
 * NOTE: These routines must carefully preserve the
 * caller's interrupt flag.
 */

#ifndef OSKIT
#define OSKIT
#endif

#define OSKIT_INCLUDE

#if 1
#define DEBUG_MSG()     printf("%s:%d:\n", __FILE__, __LINE__);
#else
#define DEBUG_MSG()
#endif

#include <flux/fdev.h>
#include <flux/x86/proc_reg.h>

#include <linux/sched.h>
#include <linux/fs.h>
#include <linux/blkdev.h>

struct tq_struct tq_last =
{
  &tq_last, 0, 0, 0
};

DECLARE_TASK_QUEUE(tq_timer);

void
tqueue_bh(void *unused)
{
	run_task_queue(&tq_timer);
}

void
add_wait_queue(struct wait_queue **q, struct wait_queue *wait)
{
#if 0
	unsigned flags;

	flags = linux_save_flags();
#endif
	printf("ADD_WAIT_QUEUE!  WE'RE HOSED!\n");

	linux_event_block(q);		/* this was nonblocking! */
#if 0
	linux_restore_flags(flags);
#endif
}

void
remove_wait_queue(struct wait_queue **q, struct wait_queue *wait)
{
#if 0
	unsigned flags;

	flags = linux_save_flags();
#endif
	linux_event_unblock(q);
	DEBUG_MSG();
#if 0
	linux_restore_flags(flags);
#endif
}

void
__down(struct semaphore *sem)
{
#if 0
	unsigned flags;

	flags = linux_save_flags();
	linux_cli();
#endif
	while (sem->count <= 0)
		linux_event_block(&sem->wait);

#if 0
	linux_restore_flags(flags);
#endif
}

void
__sleep_on(struct wait_queue **q, int interruptible)
{
	linux_event_block(q);
}

void
sleep_on(struct wait_queue **q)
{
	__sleep_on(q, 0);
}

void
interruptible_sleep_on(struct wait_queue **q)
{
	__sleep_on(q, 1);
}

void
wake_up(struct wait_queue **q)
{
	linux_event_unblock(q);
}

void
__wait_on_buffer(struct buffer_head *bh)
{
	unsigned flags;

	flags = linux_save_flags();
	linux_cli();

	while (buffer_locked(bh)) {
		bh->b_wait = (struct wait_queue *)1;
		linux_event_block(&bh->b_wait);

		linux_cli();
	}

	linux_restore_flags(flags);
}

void
unlock_buffer(struct buffer_head *bh)
{
	unsigned flags;

	flags = get_eflags();
	cli();
	clear_bit (BH_Lock, &bh->b_state);
	if (bh->b_wait) {
		bh->b_wait = 0;
		wake_up(&bh->b_wait);
	}
	set_eflags(flags);
}

void
schedule()
{
	printf("SCHEDULE!\n");
#if 0
	unsigned flags;
	flags = linux_save_flags();
	linux_event_block(0);
	linux_restore_flags(flags);
#endif
}


void
linux_event_block(void *event) 
{
	unsigned flags;

	flags = linux_save_flags();
	linux_cli();

	fdev_event_block(event);

	linux_restore_flags(flags);
}


