/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <flux/anno.h>
#include <flux/debug.h>

struct anno_entry *anno_find_exact(struct anno_table *tab, integer_t val1)
{
	struct anno_entry *low = tab->start;
	struct anno_entry *high = tab->end;

	assert(low); assert(high);

	while (high > low)
	{
		struct anno_entry *mid = low + (unsigned)(high - low) / 2;

		if (val1 < mid->val1)
		{
			high = mid;
		}
		else if (val1 > mid->val1)
		{
			low = mid + 1;
		}
		else
			return mid;
	}

	return 0;
}

