/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <string.h>
#include <flux/x86/multiboot.h>
#include <flux/x86/base_vm.h>
#include <flux/x86/pc/base_multiboot.h>

struct multiboot_module *base_multiboot_find(const char *string)
{
	struct multiboot_module *m = (struct multiboot_module*)
		phystokv(boot_info.mods_addr);
	unsigned i;

	if (!(boot_info.flags & MULTIBOOT_MODS))
		return 0;

	for (i = 0; i < boot_info.mods_count; i++)
	{
		if ((m[i].string) &&
		    (strcmp((char*)phystokv(m[i].string), string) == 0))
			return &m[i];
	}

	return 0;
}

