/*
 * Remote PC serial-line debugging for the Flux OS Toolkit
 * Copyright (C) 1996-1994 Sleepless Software
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *	Author: Bryan Ford
 */
/*
 * Remote GDB debugging through COM port on a PC.
 */

#include <flux/gdb.h>
#include <flux/gdb_serial.h>
#include <flux/tty.h>
#include <flux/x86/pio.h>
#include <flux/x86/seg.h>
#include <flux/x86/base_idt.h>
#include <flux/x86/base_gdt.h>
#include <flux/x86/base_trap.h>
#include <flux/x86/pc/pic.h>
#include <flux/x86/pc/base_irq.h>
#include <flux/x86/pc/com_cons.h>

extern void gdb_pc_com_intr();
extern unsigned gdb_pc_com_irq;

void gdb_pc_com_init(int com_port, struct termios *com_params)
{
	int com_irq = com_port & 1 ? 4 : 3;

	/* Tell the generic serial GDB code
	   how to send and receive characters.  */
	gdb_serial_recv = com_cons_getchar;
	gdb_serial_send = com_cons_putchar;

	/* Tell the GDB proxy trap handler to use the serial stub.  */
	gdb_signal = gdb_serial_signal;

	/* Hook in the GDB proxy trap handler as the main trap handler.  */
	base_trap_handler = gdb_trap;

	/*
	 * Initialize the serial port.
	 * If no com_params were specified by the caller,
	 * then default to base_raw_termios.
	 * (If we just passed through the NULL,
	 * then com_cons_init would default to base_cooked_termios,
	 * which messes up the GDB remote debugging protocol.)
	 */
	if (com_params == 0)
		com_params = &base_raw_termios;
	com_cons_init(com_port, com_params);

	/* Hook the COM port's hardware interrupt.
	   The com_cons itself uses only polling for communication;
	   the interrupt is only used to allow the remote debugger
	   to stop us at any point, e.g. when the user presses CTRL-C.  */
	fill_irq_gate(com_irq, (unsigned)gdb_pc_com_intr, KERNEL_CS, ACC_PL_K);
	gdb_pc_com_irq = com_irq;

	/* Enable the COM port interrupt.  */
	com_cons_enable_receive_interrupt();
	pic_enable_irq(com_irq);
}

