/* 
 * Copyright (c) 1995 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <malloc.h>
#include <flux/lmm.h>
#include <flux/x86/base_vm.h>
#include <flux/x86/pc/phys_lmm.h>

void phys_lmm_add(vm_offset_t min_pa, vm_size_t size)
{
	vm_offset_t max_pa = min_pa + size;

	/* Add the memory region to the malloc_lmm.
	   The LMM package will take care of splitting it up if necessary.  */
	lmm_add_free(&malloc_lmm, (void*)phystokv(min_pa), size);

	if (max_pa > phys_mem_max)
		phys_mem_max = max_pa;
}

