/* 
 * Copyright (c) 1995 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <malloc.h>
#include <flux/lmm.h>
#include <flux/x86/base_vm.h>
#include <flux/x86/pc/phys_lmm.h>

static int inited;
static struct lmm_region reg1mb, reg16mb, reghigh;

void phys_lmm_init(void)
{
	/* It woudn't be good to add these regions more than once.  */
	if (inited) return;
	inited = 1;

	lmm_add_region(&malloc_lmm, &reg1mb,
			(void*)phystokv(0x00000000), 0x00100000,
			LMMF_1MB | LMMF_16MB, LMM_PRI_1MB);
	lmm_add_region(&malloc_lmm, &reg16mb,
			(void*)phystokv(0x00100000), 0x00f00000,
			LMMF_16MB, LMM_PRI_16MB);
	lmm_add_region(&malloc_lmm, &reghigh,
			(void*)phystokv(0x01000000), 0xfeffffff,
			0, LMM_PRI_HIGH);
}

