/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <stdio.h>
#include <flux/x86/base_paging.h>

void pdir_dump(vm_offset_t pdir_pa)
{
	pd_entry_t *pdir = pdir_find_pde(pdir_pa, 0);
	unsigned pdn, pdm;

	printf("Page directory at pa %08x (kva %08x):\n",
		pdir_pa, phystokv(pdir_pa));
	for (pdn = 0; pdn < NPDES; pdn++)
	{
		/* Ignore invalid entries.  */
		if (!(pdir[pdn] & INTEL_PDE_VALID))
			continue;

		/* If this is a page table mapping, dump the page table.  */
		if (!(pdir[pdn] & INTEL_PDE_SUPERPAGE))
		{
			vm_offset_t ptab_pa = pde_to_pa(pdir[pdn]);

			printf("\t%08x-%08x -> Page table at pa %08x (kva %08x)"
				"%s%s%s%s%s\n",
				pdenum2lin(pdn), pdenum2lin(pdn+1)-1,
				ptab_pa, phystokv(ptab_pa),
				pdir[pdn] & INTEL_PDE_REF ? " REF" : "",
				pdir[pdn] & INTEL_PDE_NCACHE ? " NCACHE" : "",
				pdir[pdn] & INTEL_PDE_WTHRU ? " WTHRU" : "",
				pdir[pdn] & INTEL_PDE_USER ? " USER" : "",
				pdir[pdn] & INTEL_PDE_WRITE ? " WRITE" : "");
			ptab_dump(ptab_pa, pdenum2lin(pdn));
			continue;
		}

		/* Scan for a contiguous range of superpage mappings.  */
		for (pdm = pdn+1; pdm < NPDES; pdm++)
		{
			if (pdir[pdm] != pdir[pdm-1] + 4*1024*1024)
				break;
		}

		printf("\t%08x-%08x -> %08x-%08x%s%s%s%s%s%s%s\n",
			pdenum2lin(pdn), pdenum2lin(pdm)-1,
			pde_to_pa(pdir[pdn]),
			pde_to_pa(pdir[pdm-1]) + 4*1024*1024 - 1,
			pdir[pdn] & INTEL_PDE_GLOBAL ? " GLOBAL" : "",
			pdir[pdn] & INTEL_PDE_MOD ? " MOD" : "",
			pdir[pdn] & INTEL_PDE_REF ? " REF" : "",
			pdir[pdn] & INTEL_PDE_NCACHE ? " NCACHE" : "",
			pdir[pdn] & INTEL_PDE_WTHRU ? " WTHRU" : "",
			pdir[pdn] & INTEL_PDE_USER ? " USER" : "",
			pdir[pdn] & INTEL_PDE_WRITE ? " WRITE" : "");

		pdn = pdm-1;
	}
}

