/* 
 * Copyright (c) 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#include <stdio.h>
#include <flux/x86/base_paging.h>

void ptab_dump(vm_offset_t ptab_pa, vm_offset_t base_la)
{
	pt_entry_t *ptab = ptab_find_pte(ptab_pa, 0);
	unsigned ptn, ptm;

	for (ptn = 0; ptn < NPTES; ptn++)
	{
		/* Ignore invalid entries.  */
		if (!(ptab[ptn] & INTEL_PTE_VALID))
			continue;

		/* Scan for a contiguous range of page mappings.  */
		for (ptm = ptn+1; ptm < NPTES; ptm++)
		{
			if (ptab[ptm] != ptab[ptm-1] + 4096)
				break;
		}

		printf("\t\t%08x-%08x -> %08x-%08x%s%s%s%s%s%s%s\n",
			base_la + ptenum2lin(ptn),
			base_la + ptenum2lin(ptm)-1,
			pte_to_pa(ptab[ptn]),
			pte_to_pa(ptab[ptm-1]) + 4095,
			ptab[ptn] & INTEL_PTE_GLOBAL ? " GLOBAL" : "",
			ptab[ptn] & INTEL_PTE_MOD ? " MOD" : "",
			ptab[ptn] & INTEL_PTE_REF ? " REF" : "",
			ptab[ptn] & INTEL_PTE_NCACHE ? " NCACHE" : "",
			ptab[ptn] & INTEL_PTE_WTHRU ? " WTHRU" : "",
			ptab[ptn] & INTEL_PTE_USER ? " USER" : "",
			ptab[ptn] & INTEL_PTE_WRITE ? " WRITE" : "");

		ptn = ptm-1;
	}
}

