/*
 * Copyright (c) 1994 The University of Utah and
 * the Computer Systems Laboratory (CSL).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * Common, private stuff for libmemdebug
 */
#ifndef _OSKIT_LIBMEMDEBUG_MEMDEBUG_H
#define _OSKIT_LIBMEMDEBUG_MEMDEBUG_H

#include <malloc.h>

/*
 * Some configuration options for the library:
 */
/* Have the program _panic_ when memory can't be allocated. */
#define NO_MEM_FATAL 0

/* Debug the debugger: */
#if 0
#define DPRINTF(fmt, args... ) memdebug_printf(__FUNCTION__  ":" fmt , ## args)
#else
#define DPRINTF(fmt, args... )
#endif


/*
 * Since there are effectively two classes of memory allocation calls,
 * malloc()-style and smalloc()-style, we differentiate them, _and_
 * double check that alloc-style matches free-style.
 */
#define SMALLOC_CALLER  0x0
#define MALLOC_CALLER   0xF

/*
 * Memory chunks are wiped with different values depending on why.
 * Ideally this should aid in debugging.
 */
#define MALLOC_INIT  0x00bb
#define FREE_WIPE    0x00dd

#define SMALLOC_INIT 0x00aa
#define SFREE_WIPE   0x00ee

/*
 * Values for the "magic" field of the fences.  head and tail are set
 * in the respective fence, when its allocated (and checked when its
 * freed).  both are set to FREE_MAGIC after they've been released.
 */
#define HEAD_MAGIC 0x68454164   /* == "hEAd" */
#define TAIL_MAGIC 0x7441496C   /* == "tAIl" */
#define FREE_MAGIC 0x66524565   /* == "fREe" */

#define MHEAD_DEADBEEF 4
#define MHEAD_BTLEN 8 

#define NO_FLAGS        0
#define MARKED_FLAG     1
#define SMALLOC_CREATED 2

typedef struct memdebug_mhead
{
      unsigned magic;
      /* size is the size the _user requested_ (NOT block plus fences) */
      unsigned size;
      struct memdebug_mhead *next;
      struct memdebug_mhead *prev;
      char *file;
      int  line;
      unsigned flags;
      unsigned backtrace[MHEAD_BTLEN];
      unsigned deadbeef[MHEAD_DEADBEEF];
} memdebug_mhead;

/*
 * Define the smallest power of two greater than
 * sizeof(memdebug_mhead).  An assert will back me up.  size == (7 + 8
 * + 4) * 4 == 96 bytes!!  Yeow.
 */
#define NP2_SZ_MHEAD (128)

#define MTAIL_DEADBEEF 4
typedef struct memdebug_mtail
{
      unsigned deadbeef[MTAIL_DEADBEEF];
      unsigned size;
      unsigned magic;
} memdebug_mtail;

extern memdebug_mhead memdebug_all_head; /* defined in malloc_debug.c */

int memdebug_printf(const char *fmt, ...);

void* memdebug_alloc(size_t alignment, size_t bytes, char initval, 
		      char caller, char *file, int line);

int memdebug_free(void* mem, int wipeval, char caller, int blocksize,
		  char *file, int line);

void memdebug_bogosity(memdebug_mhead *head);

int memdebug_ptrchk(void *ptr);
int memdebug_traced_ptrchk(void *ptr, char *file, int line);

void file_info_print(const char *str, const char *file, int line);

#endif _OSKIT_LIBMEMDEBUG_MEMDEBUG_H
