/*
 * Copyright (c) 1994 The University of Utah and
 * the Computer Systems Laboratory (CSL).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */
/*
 * The mark & sweep code for checking for memory leaks.
 *
 * Call malloc_mark(), then at a later point when the
 * memory image should be (effectively) unchanged--all
 * malloc'd memory has been free'd--call malloc_check().
 *
 * Hey, its not Purify(TM), but it works.
 */

#include <stdio.h>

#include "memdebug.h"

/*
 * memdebug_mark()
 *
 * Mark all existing blocks in the list.
 */
void 
memdebug_mark(void)
{
	memdebug_mhead *h;

	memdebug_printf("MALLOC_MARK()\n");
	mem_lock();
	for (h = memdebug_all_head.next; h != &memdebug_all_head; h = h->next)
		h->flags |= MARKED_FLAG;
	mem_unlock();
}

/*
 * memdebug_sweep()
 *
 * Sweep through all pointers and make sure they're fine...
 */
void
memdebug_sweep(void)
{
	memdebug_mhead *h;

	DPRINTF("memdebug_sweep()\n");
	
	mem_lock();
	for (h = memdebug_all_head.next; h != &memdebug_all_head; h = h->next)
	{
		if (memdebug_traced_ptrchk(h + 1, 0, 0))
			memdebug_printf("NOTE: detected during a memdebug_sweep()\n");
	}
	mem_unlock();
}

/*
 * memdebug_check
 *
 * Any block that isn't marked, was created after the last call to
 * memdebug_mark(), and is an error.
 */
void 
memdebug_check(void)
{
	memdebug_mhead *h;

	memdebug_printf("MALLOC_CHECK():\n");
	mem_lock();
	for (h = memdebug_all_head.next; h != &memdebug_all_head; h = h->next)
	{
		if (!(h->flags & MARKED_FLAG))
		{
			memdebug_printf("MALLOC BOGOSITY: Unfreed block. addr = %p\n", h + 1);
			memdebug_bogosity(h);
		}

		/* Check validity of all recorded ptrs... */
		memdebug_traced_ptrchk(h + 1, 0, 0);
	}
	mem_unlock();
	memdebug_printf("MALLOC_CHECK() done\n");
}

