#include <linux/kernel.h>
#include <linux/config.h>
#include <linux/fs.h>
#include <linux/major.h>
#include <linux/blkdev.h>

#include <l4/kdebug.h>

#include <services/client/ide.h>
#include <services/lib/nameservice.h>


static int stub_block_ioctl (struct inode *inode, struct file *file,
			     unsigned int cmd, unsigned long arg)
{
	enter_kdebug(__FUNCTION__);
	return 0;
}

static int stub_block_open(struct inode * inode, struct file * filp)
{
	enter_kdebug(__FUNCTION__);
	return 0;
}

static int stub_block_release(struct inode * inode, struct file * file)
{
	enter_kdebug(__FUNCTION__);
	return 0;
}

static ssize_t stub_block_write(struct file * filp, const char * buf,
			 size_t count, loff_t *ppos)
{
	printk("block_write: %x, %x, %x, %x\n", filp, buf, count, *ppos);
	return block_write(filp, buf, count, ppos);
}

static ssize_t stub_block_read(struct file * filp, char * buf, 
			       size_t count, loff_t *ppos)
{
	enter_kdebug(__FUNCTION__);
	printk("block_read: %x, %x, %x, %x\n", filp, buf, count, *ppos);
	return block_read(filp, buf, count, ppos);
}

static int stub_block_fsync(struct file *filp, struct dentry *dentry)
{
	return block_fsync(filp, dentry);
}


#if 0
struct file_operations stub_blk_fops[] = {{
	NULL,			        /* lseek - default */
	block_read,     		/* read - general block-dev read */
	block_write,	        	/* write - general block-dev write */
	NULL,			        /* readdir - bad */
	NULL,			        /* poll */
	stub_block_ioctl,		/* ioctl */
	NULL,			        /* mmap */
	stub_block_open,		/* open */
	NULL,			        /* flush */
	stub_block_release,		/* release */
	block_fsync,		        /* fsync */
	NULL,			        /* fasync */
	NULL,	                        /* check_media_change */
	NULL, 	                        /* revalidate */
}};
#else
struct file_operations stub_blk_fops[] = {{
	NULL,			        /* lseek - default */
	stub_block_read,     		/* read - general block-dev read */
	stub_block_write,        	/* write - general block-dev write */
	NULL,			        /* readdir - bad */
	NULL,			        /* poll */
	stub_block_ioctl,		/* ioctl */
	NULL,			        /* mmap */
	stub_block_open,		/* open */
	NULL,			        /* flush */
	stub_block_release,		/* release */
	stub_block_fsync,	        /* fsync */
	NULL,			        /* fasync */
	NULL,	                        /* check_media_change */
	NULL, 	                        /* revalidate */
}};
#endif

/* blkdev test stuff */
struct request *blkdev_queue = NULL;
struct sec_size ide_sec = {512, 9};
sm_service_t idedrv;


static void blkdev_io(struct request * req)
{
	sm_exc_t exc;
#if 0
	printk("req: %x\n", req);
	printk("block_request: cmd: %d, sect: %d, "
	       "nr_sect: %d, buffer: %x\n",
	       req->cmd, req->sector, req->nr_sectors, req->buffer);
#endif
	if (req->cmd == 0) {
		l4_strdope_t strdope = rcv_refstring(req->nr_sectors * 512, req->buffer);
		ide_sys_read(idedrv, req->sector, req->nr_sectors, 
			     &strdope, &exc);
		if (flick_is_exception(&exc)) 
			panic("ide exception: %d\n", exc._type);
	}
	else {
		ide_sys_write(idedrv, req->sector, req->nr_sectors, 
			      snd_refstring(req->nr_sectors * 512, 
					    req->buffer),
			      &exc);

		if (flick_is_exception(&exc)) 
			panic("ide exception: %d\n", exc._type);
	}
}


#if 0
/* this is the first implementation - currently unused
 * it uses the linux request-queue model
 */
static void blkdev_request() {
	sm_exc_t exc;
	struct request* req = blkdev_queue;
	printk("req: %x\n", req);
	while(req) {
		printk("block_request: cmd: %d, sect: %d, "
		       "nr_sect: %d, buffer: %x\n",
		       req->cmd, req->sector, req->nr_sectors, req->buffer);
		if (req->cmd == 0) {
			ide_sys_read(idedrv, req->sector, req->nr_sectors, 
				     (dword_t)req->buffer, &exc);
			if (flick_is_exception(&exc)) 
				panic("ide exception: %d\n", exc._type);
		}
		else {
			ide_sys_write(idedrv, req->sector, req->nr_sectors, 
				      (dword_t)req->buffer, &exc);
			if (flick_is_exception(&exc)) 
				panic("ide exception: %d\n", exc._type);
		}
		req = req->next;
	}
	enter_kdebug(__FUNCTION__);
}


struct request **blkdev_get_queue(kdev_t dev)
{
	enter_kdebug(__FUNCTION__);
	return &blkdev_queue;
}
#endif

int init_block_stub(kdev_t dev, char* name, void* service)
{
	dword_t dummy;
	sm_exc_t exc;

	int maj = MAJOR(dev);
	if (register_blkdev(maj, name, stub_blk_fops)) 
	{
		printk("Unable to register block-device stub for %s (%d)\n",
		       name, MAJOR(dev));
	}

#if 0
	blk_dev[maj].request_fn = blkdev_request;
	blk_dev[maj].queue = blkdev_get_queue;
#else
	blk_dev[maj].blkio_fn = blkdev_io;
#endif

	/* now register the ide-driver - hack for the time beeing */
	idedrv = nameservice_get_service("idedrv");
	if (l4_is_invalid_id(idedrv))
		panic("pfs: ide driver does not exist!");

	ide_sys_open(idedrv, 0, &dummy, &exc);
	if (flick_is_exception(&exc))
		panic("pfs: error opening ide driver\n");

	printk("device: %x (%x)\n", maj, dev);
	enter_kdebug("blockdev init done");

	return 0;
}
	

