#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>

#include <asm/page.h>
#include <asm/semaphore.h>

#ifdef PFS_ON_LINUX
#include <stdio.h>
#endif

unsigned long jiffies;

/* mm/memory.c */
unsigned long max_mapnr = 0;
unsigned long num_physpages = 100;
mem_map_t * mem_map;

/* kernel/sched.c */
volatile struct timeval xtime __attribute__ ((aligned (16)));

struct kernel_stat kstat;

unsigned long event;

void startup() {
    
}

asmlinkage void __down_failed(void /* special register calling convention */)
{

}

asmlinkage int  __down_failed_interruptible(void  /* params in registers */)
{

}

asmlinkage void __down(struct semaphore * sem) {

}

asmlinkage int  __down_interruptible(struct semaphore * sem)
{

}

asmlinkage void __up_wakeup(void /* special register calling convention */)
{
}

asmlinkage void __up(struct semaphore * sem)
{
}

void vmtruncate(struct inode * inode, unsigned long offset)
{
	printk(__FUNCTION__"\n");
}

int in_group_p(gid_t grp)
{
        if (grp != current->fsgid) {
                int i = current->ngroups;
                if (i) {
                        gid_t *groups = current->groups;
                        do {
                                if (*groups == grp)
                                        goto out;
                                groups++;
                                i--;
                        } while (i);
                }
                return 0;
        }
out:
        return 1;
}

void schedule(void) 
{
	enter_kdebug(__FUNCTION__);
	//printk(__FUNCTION__"\n");
}

/*
void wake_up(struct wait_queue ** p)
{
	printk("wake_up\n");
}*/

int try_to_free_pages()
{
	printk(__FUNCTION__);
	return 1;
}

int in_interrupt()
{
	return 0;
}

void wait_for_keypress(void)
{
	printk(__FUNCTION__);
}

// normally returns 0 if everything was ok.
int copy_from_user(void* to, void* from, int size)
{
	memcpy(to, from, size);
	return 0;
}

int copy_to_user(void* to, void* from, int size)
{
	memcpy(to, from, size);
	return 0;
}

long strncpy_from_user(char *dst, const char *src, long count)
{
	return strncpy(dst, src, count);
}


void interruptible_sleep_on(struct wait_queue ** p)
{
	printk(__FUNCTION__);
}

int send_sig(int sig, struct task_struct * p, int priv)
{
	printk(__FUNCTION__);
	return 0;
}

#if 0
struct dentry * __namei(const char *pathname, unsigned int lookup_flags)
{
	printk("namei lookup %s\n", pathname);
	return NULL;
}
#endif

void __wake_up(struct wait_queue ** p, unsigned int mode)
{
	//printk("#");
}

void sleep_on(struct wait_queue ** p)
{
	printk(__FUNCTION__);
}

void* sm_malloc(long size)
{
	return kmalloc(size, 0);
}

void sm_free(void* ptr)
{
	kfree(ptr);
}
