#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <l4/syscalls.h>
#include <l4/kdebug.h>

#include <services/lib/nameservice.h>

#define SERVICE_PREFIX "/services/"
#define MAX_NAME 200


static sm_service_t nameservice = L4_INVALID_ID;


int nameservice_init()
{
	if (l4_is_invalid_id(nameservice)) 
		nameservice.dw = 0x04050001;
	return 1;
}	

int nameservice_resolve(char* name, handle_t *handle, sm_service_t *service)
{
	char buf[MAX_NAME];
	nameservice_name_t unresolved = (nameservice_name_t)&buf;
	sm_exc_t exc;
	sm_service_t tmp_service;
	*handle = -1;

	nameservice_init();

	nameservice_name_resolve(nameservice, name, 
				 (service_t*)&tmp_service, 
				 &unresolved, 
				 handle, &exc);

	while (exc._type == exc_l4_no_exception) {
		//printf("resolve: %x, %x\n", *handle, *service);
		if (*handle != -1) {
			*service = tmp_service;
			return 1;
		}
		nameservice_name_resolve(tmp_service, buf, 
					 (service_t*)&tmp_service, 
					 (nameservice_name_t*)&buf, 
					 handle, &exc);
	}
	return 0;
}

int nameservice_register(char* name, handle_t handle, sm_service_t service)
{
	sm_exc_t exc;

	nameservice_init();

	nameservice_name_register(nameservice, name, handle, 
				  *(service_t*)&service, &exc);
	return (exc._type == exc_l4_no_exception);
}

int nameservice_unregister(char* name)
{
	sm_exc_t exc;
	nameservice_init();
	nameservice_name_unregister(nameservice, name, &exc);
	return (exc._type == exc_l4_no_exception);
}


int nameservice_register_service(char* name)
{
	char buffer[MAX_NAME];
	nameservice_init();
	sprintf(buffer, SERVICE_PREFIX "%s", name);
	nameservice_unregister(buffer);
	return nameservice_register(buffer, 0, l4_myself());
}

sm_service_t nameservice_get_service(char* name)
{
	sm_service_t tmp_service;
	handle_t handle;
	char buffer[MAX_NAME];
	nameservice_init();
	sprintf(buffer, SERVICE_PREFIX "%s", name);
	if (nameservice_resolve(buffer, &handle, &tmp_service)) {
		return tmp_service;
	}
	return L4_INVALID_ID;
}

int nameservice_unregister_service(char* name)
{
	char buffer[MAX_NAME];
	nameservice_init();
	sprintf(buffer, SERVICE_PREFIX "%s", name);
	return nameservice_unregister(buffer);
}
