#include "globals.h"
#include <l4/kdebug.h>
#include <l4/librmgr.h>

void taskserv_def_server_create(sm_request_t *request, 
				taskserv_ln_threadid_t initial_pager, 
				l4_strdope_t pager_info, 
				sdword_t eip, 
				sdword_t esp, 
				sdword_t prio, 
				sdword_t timeslice, 
				taskserv_smtask_t *task, 
				sm_exc_t *_ev)
{
  int i; 
  l4_taskid_t reqtask, createdtask;


  if (debug) printf("taskserv: received create request\n");
  if (debug) printf("taskserv: args pager %x eip %x esp %x prio %x slice %x\n",
	 initial_pager, eip, esp, prio, timeslice);

  _ev->_type = 0; /* no error (yet) */
  
  /* do some quick sanity checks
   * 	- pager cannot be nil
   * 	- security checks should eventually be here
   */
  if (l4_is_nil_id(*(l4_threadid_t*) &initial_pager)) {/* Hmmm, a real
						        * language
						        * would be
						        * nice
						        */
    _ev->_type = E_TASKSERV_CREATEERR;
    return;
  }

  /* scan to get a task
   * 	- try to create each free task in turn until one works.
   * 	- if we try them all, then fail. 
   */
  createdtask = L4_NIL_ID;
  i = last_task;
  do {
    i++;
    if (i == NUM_TASKS) {
      i = 0;
    }
    if (i == last_task) {
      /* no tasks left ???*/
      _ev->_type = E_TASKSERV_CREATEERR;
      return;
    }
    /* convert priority and timeslice specs from clients into L4 encodings
     */
    if (l4_is_nil_id(tasks[i].pager) && tasks[i].num_notifiees == 0) {
      l4_sched_param_t sched;
      sched.sched_param = 0;
      sched.sp.prio = prio;
      if (timeslice == 0) {
	sched.sp.time_exp = 1;
	sched.sp.time_man = 0;
      }
      else {
	unsigned int t;
	int e;
	t = timeslice;
	e = 0;
	while (t & 0xffffff00) {
	  t = t >> 2;
	  e++;
	}
	e = 15 - e;
	if (e <= 0) {
	  /* value is greater than maximum we can encode, so set the
	   * maximum time we can.
	   */
	  sched.sp.time_exp = 1;
	  sched.sp.time_man = 255;
	}
	else {
	  sched.sp.time_exp = e;
	  sched.sp.time_man = t;
	}
      }
#if 0
      if (debug) {
	printf("timeslice %d = %d * 4 ^ (15 - %d)\n", timeslice, 
	       sched.sp.time_man,  sched.sp.time_exp);
      }
#endif      
      reqtask = tasks[i].tid;
      reqtask.id.version_low ++;
      if (debug) printf("taskserv: attempting to create task %x\n", reqtask.dw);
      /* try to create task */
      createdtask = rmgr_task_new_with_prio(reqtask, 
					       INITIAL_MCP, 
					       esp, 
					       eip, 
					       *((l4_threadid_t *) 
						 &initial_pager), 
					       sched);
      if (debug) printf("taskserv: result of create task %x\n", createdtask.dw);  
    }
  } while (createdtask.dw == 0xffffffff); /* rmgr returns -1 on
					   * task_new failure 
					   */
  
  /* copy the info about the new task 
   */
  tasks[i].tid = createdtask;
  tasks[i].pager.dw =  initial_pager;
  
  /* copy the info for the pager
   */
  if (debug) printf("taskserv: new info size %x\n", pager_info.snd_size);
  
  if (pager_info.snd_size > 0 &&
      pager_info.snd_size <= TASKSERV_MAX_PAGER_INFO_LEN) {
    int j;
    tasks[i].info_length =  pager_info.snd_size;
    for (j = 0; j < pager_info.snd_size; j++) {
      tasks[i].info[j] = ((char *) (pager_info.snd_str))[j]; 
    }
  }
  else {
    tasks[i].info_length = 0;
  }

  /* remember where we left off and return new task id
   */
  last_task = i;
  *task = createdtask.dw;
}

