#include "globals.h"
#include <l4/kdebug.h>
#include <l4/librmgr.h>

void taskserv_def_server_delete(sm_request_t *request, 
				taskserv_smtask_t task, 
				sm_exc_t *_ev)
{
  l4_threadid_t tk;
  l4_msgdope_t result;
  int r;
  
  /* some quick sanity checks
   * 	- task id is in range
   * 	- task is created
   * 	- security model check should be here 
   */
  if (debug) printf("taskserv: deleting task %x\n", task);
  tk = *(l4_threadid_t *) &task; 
  if (tk.id.task < LOW_TASK ||
      tk.id.task > HIGH_TASK) {
    _ev->_type = E_TASKSERV_DELERR;
    return;
  }
  if (l4_is_nil_id(tasks[tk.id.task - LOW_TASK].pager)) {
    _ev->_type = E_TASKSERV_DELERR;
    return;
  }
  
  /* do the deed */
  r = rmgr_delete_task(tk.id.task);
  if (r != 0) {
    _ev->_type = E_TASKSERV_DELERR;
  }
  else {
    /* mark slot free and prod notifier thread */
    tasks[tk.id.task - LOW_TASK].pager = L4_NIL_ID;

    /* need to add notification eventually */
    tasks[tk.id.task - LOW_TASK].num_notifiees = 0;
    
    /*
       if (tasks[tk.id.task - LOW_TASK].num_notifiees > 0) {
       rc = l4_i386_ipc_send(notifier_thread,
       L4_IPC_SHORT_MSG,
       tk.id.task - LOW_TASK, 0, 0,
       L4_IPC_TIMEOUT(0,1,0,1,0,15,15),
       &result);
       }
       */
  }
  if (debug) printf("taskserv: delete suceeded\n");
  return;
}



