#include "globals.h"
#include <l4/kdebug.h>

void taskserv_def_server_exists(sm_request_t *request, 
				taskserv_smtask_t task, 
				byte_t *bool, 
				sm_exc_t *_ev)
{
   l4_threadid_t tk;
   tk = *(l4_threadid_t *) &task; 
   
   /* some quick sanity checks
    * 	- task id is in range
    * 	- security model check should be here 
    */
   if (tk.id.task < LOW_TASK ||
       tk.id.task > HIGH_TASK) {
     _ev->_type = E_TASKSERV_DELERR;
     return;
   }
   
   /* return state */
   *bool = !l4_is_nil_id(tasks[tk.id.task - LOW_TASK].pager) ;
   
   return;
}

