#include "globals.h"


void taskserv_def_server_get_pager_info(sm_request_t *request, 
					taskserv_smtask_t task, 
					l4_strdope_t *pager_info,
					sm_exc_t *_ev)
{
  l4_threadid_t tk;
  /* some quick sanity checks
   * 	- task id is in range
   * 	- requester is pager
   * 	- security model check should be here 
   */
  _ev->_type = 0; /* set no error */
  tk = *(l4_threadid_t *) &task; /* yucky cast */

  if (debug) printf("taskserv: get pager info for task %x\n", task);
  if (tk.id.task < LOW_TASK ||
      tk.id.task > HIGH_TASK) {
    _ev->_type = E_TASKSERV_GETINFOERR;
    return;
  }
  if (!task_equal(
		  tasks[tk.id.task - LOW_TASK].pager,
		  request->client_tid) ) {
    _ev->_type = E_TASKSERV_GETINFOERR;
    return;
  }
 
  /* return pager info */
  pager_info->snd_size  = tasks[tk.id.task - LOW_TASK].info_length;
  pager_info->snd_str = (dword_t) &tasks[tk.id.task - LOW_TASK].info[0];
  return;
}
