#ifndef __GLOBALS_H__
#define __GLOBALS_H__

#include <l4/types.h>
#include <services/server/taskserv.h>

#define MAX_L4_TASKS 256
#define INITIAL_MCP 255
#define LOW_TASK 110
#define HIGH_TASK 219
#define NUM_TASKS    (HIGH_TASK - LOW_TASK + 1)
#define MAX_NOTIFIEES 10

extern const int debug;
extern l4_threadid_t notifier_thread;
extern l4_threadid_t main_thread;

typedef struct {
  l4_taskid_t tid;
  l4_threadid_t pager;
  dword_t info_length;
  char info[TASKSERV_MAX_PAGER_INFO_LEN];
  dword_t num_notifiees;
  l4_threadid_t notifiees[MAX_NOTIFIEES];
} task_info_t; 

extern sm_request_t request;
extern l4_ipc_buffer_t buf;
extern int last_task;
extern task_info_t tasks[NUM_TASKS];

#endif


