#include "globals.h"
#include <l4/kdebug.h>
#include <l4/librmgr.h>
#include <services/lib/nameservice.h>

const int debug = 0;
unsigned long main_stack[4096];
sm_request_t request;
l4_ipc_buffer_t buf;
task_info_t tasks[NUM_TASKS];
int last_task;
char info_buf[TASKSERV_MAX_PAGER_INFO_LEN];


int main(void) 
{  
  int i,r,t;
  l4_msgdope_t rc;
  
  if (debug) printf("taskserv: initialising\n");
  /* enter_kdebug("taskserv"); */
  
  
  /* init the region manager
   */
  if (!rmgr_init()) {
    panic("runl4: rmgr_init() failed\n");
  }
  
  /* initialise task info 
   */
  t = 0;
  for (i = 0; i < NUM_TASKS; i++) {
    tasks[i].tid.id.chief = 0;
    tasks[i].tid.id.task = i+LOW_TASK;
    tasks[i].tid.id.lthread = 0;
    tasks[i].tid.id.version_low = 0;
    tasks[i].pager = L4_NIL_ID; /* nil indicates the task is "free" or dying
				 */
    tasks[i].num_notifiees = 0;
  }
  last_task = NUM_TASKS - 1;

 
  /* register myself with the name server
   */
  if (debug) printf("taskserv: registering with name server\n");
  r = nameservice_init();
  if (!r) panic("taskserv: name serve init failed\n");
  r = nameservice_register_service("taskserv");
  if (!r) panic("taskserv: name reg failed\n");
  

  /* start servicing requests from clients
   */
  if (debug) printf("taskserv : Servicing requests\n");
  flick_init_request(&request, &buf);
  flick_set_number_rcvstring(&request, 1);
  flick_server_set_rcvstring(&request, 0, 
			     TASKSERV_MAX_PAGER_INFO_LEN,
			     &info_buf[0]);
  
  /* enter_kdebug("taskserv : waiting"); */
  if (L4_IPC_IS_ERROR(rc = flick_server_wait(&request))) {
    panic("taskserv: flick_server_wait failed %x\n",
	  rc.msgdope );
  }
  
  while (1) {
#if 0
    if (debug) printf("taskserv : received request md = %x\n",
		      rc.msgdope);
#endif

    taskserv_def_server(&request);

#if 0
    printf("taskserv: snd_dope %x size_dope %x\n",
	   request.msgbuf->snd_dope.msgdope,
	   request.msgbuf->size_dope.msgdope);
    printf("taskserv: ind_str %x ind_size %x\n",
	   request.msgbuf->str_dope[0].snd_str,
	   request.msgbuf->str_dope[0].snd_size);
#endif

    if (L4_IPC_IS_ERROR(rc = flick_server_reply_and_wait(&request))) {
      panic("taskserv: flick_server_reply_and_wait failed %x\n",
	    rc.msgdope );
    }
  }
}






