#include "globals.h"
#include <l4/kdebug.h>
#include <l4/librmgr.h>

void taskserv_def_server_notify_death(sm_request_t *request, 
				      taskserv_smtask_t task, 
				      sm_exc_t *_ev)
{
  l4_threadid_t tk;
  _ev->_type = 0; /* no error (yet) */ 
  
  /* some quick sanity checks
   * 	- task id is in range
   * 	- task is created
   * 	- space for recording notifiee
   * 	- security model check should be here 
   */
  
  if (tk.id.task < LOW_TASK ||
      tk.id.task > HIGH_TASK) {
    _ev->_type = E_TASKSERV_NOTIFYERR;
    return;
  }
  
  if (l4_is_nil_id(tasks[tk.id.task - LOW_TASK].pager)) {
    _ev->_type = E_TASKSERV_NOTIFYERR;
    return;
  }
  
  if  (tasks[tk.id.task - LOW_TASK].num_notifiees == MAX_NOTIFIEES) {
     _ev->_type = E_TASKSERV_NOTIFYERR;
     return;
   }
  
  /* record the client for notification */
  tasks[tk.id.task - LOW_TASK
	].notifiees[tasks[tk.id.task - LOW_TASK].num_notifiees
		    ] = request->client_tid;
  
  tasks[tk.id.task - LOW_TASK].num_notifiees++;
  
  return;

}

/* void notifier(void)
   {
   dword_t d1,d2,d3;
   l4_msgdope_t result;
   
   do {
   l4_i386_ipc_receive(main_thread,
   L4_IPC_SHORT_MSG,
   &d1, &d2, &d3
   L4_IPC_NEVER, &result);
   } while (1);
   }
   */
