
#include <stdio.h>
#include <services/lib/nameservice.h>
#include <services/client/taskserv.h>
#include <l4/syscalls.h>
#define STACK_SIZE 1024
long main_stack[4096];
long pager_stack[STACK_SIZE];

char info_buf1[TASKSERV_MAX_PAGER_INFO_LEN];
char info_buf2[TASKSERV_MAX_PAGER_INFO_LEN];

void pager_thread()
{
  l4_msgdope_t result;
  l4_threadid_t sender;
  dword_t d1, d2, d0;
  
  while (1) {
    l4_i386_ipc_wait(&sender, L4_IPC_NIL_DESCRIPTOR,
		 &d0, &d1, &d2, L4_IPC_NEVER, &result);
  }
}

void main(void) 
{
  int i;
  byte_t bool;
  sm_service_t ts;
  l4_threadid_t pager,prempt, p_pager;
  l4_strdope_t pager_info;
  taskserv_smtask_t task;
  dword_t d0, d1, d2, info_len;
  sm_exc_t exc;

  printf("test: initialising nameservice\n");
  nameservice_init();
  printf("test: finding task server\n");
  do {
    l4_thread_switch(L4_NIL_ID);
    ts = nameservice_get_service("taskserv");
  } while (ts.dw == 0xffffffff);
  
  printf("test: taskserv %x\n", *((int *) &ts));

  pager = l4_myself();
  p_pager.dw = 0xffffffff;

  /* get my pager */
  l4_thread_ex_regs(pager, 
		    (dword_t) 0xffffffff,
		    (dword_t) 0xffffffff,
		    &prempt, 
		    &p_pager,
		    &d0, &d1, &d2);

  /* p_pager is my current pager */
  
  printf("tester: pager thread pager %x\n", p_pager.dw);
  

  pager.id.lthread ++; /* 0 = linux, 1 = emul lib */
  prempt = L4_NIL_ID;
  
  printf("tester: starting pager thread %x\n", pager.dw);
  
  l4_thread_ex_regs(pager, 
		    (dword_t) pager_thread, 
		    (dword_t) &pager_stack[STACK_SIZE - 1],
		    &prempt, 
		    &p_pager,
		    &d0, &d1, &d2);
  
  
  printf("tester: pager thread (%x) should be started\n",
	 pager.dw);
  
  
  for (i = 0; i < 20;i++) {
    *(dword_t *)info_buf1 = ~i;
    pager_info.snd_size = 0;
    pager_info.snd_str = (dword_t) &info_buf1[0];
    pager_info.rcv_size = 0;
    taskserv_def_create(/* sm_service_t */ ts,
			/* taskserv_ln_threadid_t */ pager.dw, 
			/* l4_strdope_t */ pager_info, 
			/* sdword_t eip */ 0x1234, 
			/* sdword_t esp */ 0x4321, 
			/* sdword_t prio */ 1, 
			/* sdword_t timeslice */ 10e3, 
			/* taskserv_smtask_t */ &task, 
			/* sm_exc_t */ &exc);
     if (exc._type == 0) {
       printf("test: created %x\n", task);
     }
    else {
       printf("test: create failed %x\n", task);
     }

    pager_info.snd_size = 0;
    pager_info.rcv_str = (dword_t) &info_buf2[0];
    pager_info.rcv_size = TASKSERV_MAX_PAGER_INFO_LEN;
    
    printf("tester: gettng page info\n");
    
    taskserv_def_get_pager_info(ts, task, &pager_info, &exc);
    
    if (exc._type == 0) {
      printf("test: got info bytes %x\n", pager_info.snd_size);
    }
    else {
      printf("test: info failed \n");
    }
    
    taskserv_def_exists(ts, task, &bool, &exc);
    printf("tester: exists = %x\n", bool);

    taskserv_def_delete(ts,task,&exc);
    if (exc._type == 0) {
      printf("test: deleted %x\n", task);
    }
    else {
      printf("test: delete failed %x\n", task);
    }
    taskserv_def_exists(ts, task, &bool, &exc);
    printf("tester: exists = %x\n", bool);
    
  }
  
  enter_kdebug("done");
}
