/*
 *  linux/fs/filesystems.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  table of configured filesystems
 */

#include <linux/config.h>
#include <linux/fs.h>

#include <linux/major.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>

//#include <linux/lockd/bind.h>
//#include <linux/lockd/xdr.h>
#include <linux/init.h>
//#include <linux/nls.h>

void __init filesystem_setup(void)
{
	printk(__FUNCTION__" initialize the filesystems\n");
}

#ifndef CONFIG_NFSD
#ifdef CONFIG_NFSD_MODULE
int (*do_nfsservctl)(int, void *, void *) = NULL;
#endif
int
asmlinkage sys_nfsservctl(int cmd, void *argp, void *resp)
{
#ifndef CONFIG_NFSD_MODULE
	return -ENOSYS;
#else
	int ret = -ENOSYS;
	
	lock_kernel();
	if (do_nfsservctl) {
		ret = do_nfsservctl(cmd, argp, resp);
		goto out;
	}
#ifdef CONFIG_KMOD
	if (request_module ("nfsd") == 0) {
		if (do_nfsservctl)
			ret = do_nfsservctl(cmd, argp, resp);
	}
#endif /* CONFIG_KMOD */
out:
	unlock_kernel();
	return ret;
#endif /* CONFIG_NFSD_MODULE */
}
#endif /* CONFIG_NFSD */
