#include <linux/kernel.h>
#ifndef VFS_ON_LINUX

#else
#include <stdio.h>
#endif

static char buf[1024];

static inline 
void out_char(unsigned char c)
{
  asm(
      "int      $3      \n\t"
      "cmpb     $0,%%al \n\t"
      : /* No output */
      : "a" (c)
      );
}


asmlinkage int printk(const char * fmt, ...)
{
	va_list args;
	char *tmp = buf;

	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);


#ifndef VFS_ON_LINUX
	while(*tmp) {
		out_char(*tmp);
		if (*tmp == '\n')
			out_char('\r');
		tmp++;
	}
#else
	printf(buf);
#endif

	return 0;
}

void panic(const char * fmt, ...) 
{
	va_list args;
	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);

	printk(buf);
	printk("\nVFS Panic\n");
#ifdef VFS_ON_LINUX
	exit(0);
#else
	while(1);
#endif
}
