#include <linux/mm.h>    

extern int nr_free_pages;

void mem_init(unsigned long start_mem, unsigned long end_mem)
{
	int codepages = 0;
	int datapages = 0;
	unsigned int tmp;
	
	start_mem = PAGE_ALIGN(start_mem);
	end_mem &= PAGE_MASK;

	max_mapnr = MAP_NR(end_mem);

	for (tmp = start_mem; tmp<end_mem; tmp+= PAGE_SIZE) {
		clear_bit(PG_reserved, &mem_map[MAP_NR(tmp)].flags);
		atomic_set(&mem_map[MAP_NR(tmp)].count, 1);
		free_page(tmp);
	}
	
	printk("memory area: %x to %x\n", start_mem, end_mem);
	printk("free pages: %d\n", nr_free_pages);
}






