#include <linux/types.h>
#include <linux/sched.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/slab.h> /* for the files cache */

#include <l4/syscalls.h>
#include <services/server/vfs.h>
#include <services/lib/nameservice.h>
#include <services/sys/services.h>

#include <services/client/pfs.h>
#include <services/client/dm_anon.h>


#include <stdio.h>
#include <unistd.h>
#include <sys/mman.h>
#include <errno.h>

#define START_MEM 0x10000000
#define SIZE_MEM  0x00100000


unsigned long main_stack[4096];

sm_service_t pfsroot;
sm_service_t dm_anon;
dsid_t anon_ds_id;

void vfs_thread(void);
void init_task_structs();

/* SLAB cache for files structs */
/* comes from kernel/fork.c */
kmem_cache_t *files_cachep; 
void filescache_init(void);


int main(void) {
	unsigned long memory_start, memory_end;
	void *start;
	/* test variables */
	struct dentry* dentry;
	int fd;
	sm_request_t request;

	memory_start = START_MEM;
	memory_end = START_MEM + SIZE_MEM;

	printk(VFS_LINUX"\n");
	if (!nameservice_init()) 
		panic("Could not initialize name server\n");

	printk("start register\n");

	if (!nameservice_register_service(VFS_LINUX))
		panic("Could not register name");

	pfsroot = nameservice_get_service(PFS_EXT2);

	if (l4_is_invalid_id(pfsroot)) 
		panic("could not find ext2-filesystem");

	dm_anon = nameservice_get_service(DM_ANON);

	if (l4_is_invalid_id(dm_anon)) 
		panic("could not find anonymous dataspace manager");
	
	printk("vfs: pfs-ext2 is %x, anon dm is %x\n", pfsroot.dw, dm_anon.dw);

#ifndef VFS_ON_LINUX
	/* now we grab memory from the anonymous ds */
	{
		sm_exc_t exc;
		l4_snd_fpage_t fp;
		int i;
		/* map memory from anon_dm */
		dm_anon_ds_open(dm_anon, &anon_ds_id, &exc);
		if (flick_is_exception(&exc)) {
			panic("Could not open anonymous dataspace\n");
		}
		
		enter_kdebug("VFS: map anon dm");
		for (i = 0; i<SIZE_MEM; i+=0x1000) {
			dm_anon_ds_map_page(dm_anon, 
					    l4_fpage(START_MEM + i, 12, 0, 0),
					    anon_ds_id, 
					    i,
					    &fp,
					    &exc); 
			if (flick_is_exception(&exc)) {
				printk("error getting page %x for ds %x from anon dm\n", i, anon_ds_id);
				enter_kdebug("grab page");
			}
		}

		//enter_kdebug("map anon dm done");
	}
#else
	start = mmap((void*)START_MEM, SIZE_MEM, PROT_WRITE, MAP_FIXED | 
		     MAP_PRIVATE | MAP_ANON, -1, 0);
	if (start == MAP_FAILED) 
		panic("mmap failed (%d)\n", errno);

#endif
	memory_start = free_area_init(memory_start, memory_end);
	memory_start = kmem_cache_init(memory_start, memory_end);
	mem_init(memory_start,memory_end);

	init_task_structs();

	kmem_cache_sizes_init();

	filescache_init();
	dcache_init();
	inode_init();
	file_table_init();

	init_pfs_fs();

#if 0
	/* temporarily for testing !!! */
	request.client_tid = l4_myself();
	allocate_taskstruct(request.client_tid);
	if (!set_current(&request)) 
		panic("set current");
#endif
	mount_root();
#if 0
	printk("vfs: mkdir bla\n");
	printk("mkdir returned: %d\n", sys_mkdir("/bla", 0777));

	fd = sys_open("/", O_RDONLY, 0);
	printk("open: %d\n", fd);
	if (fd != -1) {
		dword_t dents_buffer[512];
		int i;
		int err;
		for (i = 0; i<512; i+=2) {
			dents_buffer[i]=sizeof(dents_buffer);
			dents_buffer[i+1]=dents_buffer;
		}
		printk ("opened file successfully\n");
		do {
			err = sys_getdents(fd,(struct dirent*)&dents_buffer , 
					   sizeof(dents_buffer));
			printf("getdents returned: %d\n", err);

		} while (err >0);
	}
	sys_close(fd);

	fd = sys_open("/passwd", O_RDONLY, 0);
	printk("open: %d, %x\n", fd, fd->handle);
	if (fd != -1) {
		dword_t buffer[4096];
		
		
	}
#else
	printk("VFS: do the main loop\n");
	enter_kdebug("VFS");
	
	vfs_thread();
#endif
	
	exit(1);
}


void filescache_init(void)
{
	files_cachep = kmem_cache_create("files_cache", 
					 sizeof(struct files_struct),
					 0, 
					 SLAB_HWCACHE_ALIGN,
					 NULL, NULL);
	if (!files_cachep) 
		panic("Cannot create files cache"); 
}


sm_service_t get_fs_service(kdev_t dev)
{
	return pfsroot;
}

/* this is the main handler-thread-function loop */
void vfs_thread() 
{
    sm_request_t request;
    l4_ipc_buffer_t msgbuf;
    l4_msgdope_t result;
    int ret;
    
    printk("starting thread %x\n", l4_myself());

    flick_init_request(&request, &msgbuf);
    
    while(1) {
	result = flick_server_wait(&request);
	while(!L4_IPC_ERROR(result)) {

	    /* call the server unmarshaller */
	    ret = vfs_sys_server(&request);

	    switch(ret) {
	    case DISPATCH_ACK_SEND:
		result = flick_server_reply_and_wait(&request);
		break;
	    case DISPATCH_PROPAGATE:
		panic("propagation not implemented yet");
		break;
	    case DISPATCH_NO_REPLY:
		result = flick_server_wait(&request);
		break;
	    default:
		panic("something screwed with the server-loop");
		break;
	    }
	}
    }
}



void exit(int code)
{
	panic("exit %d", code);
	while(1);
}

