#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/file.h>

#include <services/server/vfs.h>
#include <vfs/vfs.h>

sdword_t vfs_sys_server_sync(sm_request_t *request, sm_exc_t *_ev)
{
	sm_exc_t exc;
	struct super_block *sb;
	printk("vfs: sync\n");
	for (sb = sb_entry(super_blocks.next);
	     sb != sb_entry(&super_blocks); 
	     sb = sb_entry(sb->s_list.next)) 
	{
		pfs_name_sync(sb->pfs, &exc);
	}
	/* according to the manual, sync always returns zero */
	return 0;
}

sdword_t vfs_sys_server_fsync(sm_request_t *request, vfs_handle_t handle, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_fdatasync(sm_request_t *request, vfs_handle_t handle, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_handleatasync(sm_request_t *request, vfs_handle_t handle, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_bdflush(sm_request_t *request, dword_t func, sdword_t data, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_flock(sm_request_t *request, vfs_handle_t handle, dword_t cmd, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_mknod(sm_request_t *request, vfs_filename_t fname, sdword_t mode, vfs_dev_t dev, sm_exc_t *_ev)
{
	printk("vfs: mknod(%s, %d, %x)\n", fname, mode, dev);
	if (set_current(request))
		return sys_mknod(fname, mode, dev);
	return -EACCES;
}

sdword_t vfs_sys_server_mkdir(sm_request_t *request, vfs_filename_t fname, sdword_t mode, sm_exc_t *_ev)
{
	printk("vfs: mkdir(%s, %d)\n", fname, mode);
	if (set_current(request))
		return sys_mkdir(fname, mode);
	return -EACCES;
}

sdword_t vfs_sys_server_rmdir(sm_request_t *request, vfs_filename_t fname, sm_exc_t *_ev)
{
	printk("vfs: rmdir(%s)\n", fname);
	if (set_current(request))
		return sys_rmdir(fname);
	return -EACCES;
}

sdword_t vfs_sys_server_unlink(sm_request_t *request, vfs_filename_t fname, sm_exc_t *_ev)
{
	printk("vfs: unlink(%s)\n", fname);
	if (set_current(request))
		return sys_unlink(fname);
	return -EACCES;
}

sdword_t vfs_sys_server_symlink(sm_request_t *request, vfs_filename_t oldname, vfs_filename_t newname, sm_exc_t *_ev)
{
	printk("vfs: symlink(%s, %s)\n", oldname, newname);
	if (set_current(request))
		return sys_symlink(oldname, newname);
	return -EACCES;
}

sdword_t vfs_sys_server_link(sm_request_t *request, vfs_filename_t oldname, vfs_filename_t newname, sm_exc_t *_ev)
{
	printk("vfs: link(%s, %s)\n", oldname, newname);
	if (set_current(request))
		return sys_link(oldname, newname);
	return -EACCES;
}

sdword_t vfs_sys_server_readlink(sm_request_t *request, vfs_pathname_t path, vfs_pathname_t *link, sm_exc_t *_ev)
{
	printk("vfs: readlink(%s)\n", path);
	if (set_current(request))
		return sys_link(path, *link, 100);
	return -EACCES;
}

sdword_t vfs_sys_server_rename(sm_request_t *request, vfs_filename_t oldname, vfs_filename_t newname, sm_exc_t *_ev)
{
	printk("vfs: rename(%s, %s)\n", oldname, newname);
	if (set_current(request))
		return sys_rename(oldname, newname);
	return -EACCES;
}

sdword_t vfs_sys_server_utime(sm_request_t *request, vfs_filename_t fname, vfs_utimebuf_t *times, sm_exc_t *_ev)
{
	printk("vfs: utime(%s)\n", fname);
	if (set_current(request))
		return sys_utime(fname, *times);
	return -EACCES;
}

sdword_t vfs_sys_server_utimes(sm_request_t *request, vfs_filename_t fname, vfs_timeval_t *utimes, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_access(sm_request_t *request, vfs_filename_t fname, sdword_t mode, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_chdir(sm_request_t *request, vfs_filename_t fname, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_fchdir(sm_request_t *request, vfs_handle_t handle, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_chroot(sm_request_t *request, vfs_filename_t fname, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_fchmod(sm_request_t *request, vfs_handle_t handle, vfs_mode_t mode, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_chmod(sm_request_t *request, vfs_filename_t fname, vfs_mode_t mode, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_chown(sm_request_t *request, vfs_filename_t filename, vfs_uid_t user, vfs_gid_t group, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_lchown(sm_request_t *request, vfs_filename_t filename, vfs_uid_t user, vfs_gid_t group, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_fchown(sm_request_t *request, vfs_handle_t handle, vfs_uid_t user, vfs_gid_t group, sm_exc_t *_ev)
{
	return 0;
}

vfs_handle_t vfs_sys_server_open(sm_request_t *request, vfs_filename_t fname, sdword_t flags, sdword_t mode, vfs_handle_t *pfs_handle, vfs_service_t *serv, sm_exc_t *_ev)
{
	int ret = -EACCES;
	struct file * filp; 
	printk("vfs: open(%s, %d, %d)\n", fname, flags, mode);
	if (set_current(request)) {
		ret = sys_open(fname, flags, mode);
		if (ret >= 0) {
			filp = fcheck(ret);
			if (filp) {
				*pfs_handle = filp->handle;
				*serv = filp->service.dw;
			}
		}
	}
	return ret;
	
}

vfs_handle_t vfs_sys_server_close(sm_request_t *request, vfs_handle_t handle, sm_exc_t *_ev)
{
	struct file * filp;
	int ret = -EACCES;
	printk("vfs: close(%x)\n", handle);
	if (set_current(request))
		ret = sys_close(handle);
	return ret;
}


sdword_t vfs_sys_server_mount_root(sm_request_t *request, vfs_filename_t rootdev, sm_exc_t *_ev)
{
	return 0;
}

sdword_t vfs_sys_server_register_client(sm_request_t *request, threadid_t client, sdword_t uid, sdword_t gid, sm_exc_t *_ev)
{
	struct task_struct *task;
	l4_threadid_t client_tid = {dw: client};

	printk("vfs: register client %x, %o, %o\n", client, uid, gid);

	task = allocate_taskstruct(client_tid);
	atomic_inc(&task->ref_count);

	task->uid = uid;
	task->gid = gid;

	return 1;
}

sdword_t vfs_sys_server_unregister_client(sm_request_t *request, threadid_t client, sm_exc_t *_ev)
{
	return 0;
}
