/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/c/libcast.h>
#include <string.h>

cast_type cast_new_prim_type(cast_primitive_kind kind,
			     cast_primitive_modifier mod)
{
	cast_type type = cast_new_type(CAST_TYPE_PRIMITIVE);
	
	type->cast_type_u_u.primitive_type.kind = kind;
	type->cast_type_u_u.primitive_type.mod = mod;
	type->cast_type_u_u.primitive_type.name = 0;
	
	return type;
}

cast_type cast_new_prim_alias(cast_primitive_kind kind,
			      cast_primitive_modifier mod,
			      const char *alias)
{
	cast_type type = cast_new_prim_type(kind, mod);
	
	type->cast_type_u_u.primitive_type.name =
		(char **) mustmalloc(sizeof(char *));
	*(type->cast_type_u_u.primitive_type.name) =
		(char *) mustmalloc(strlen(alias) + 1);
	strcpy(*(type->cast_type_u_u.primitive_type.name), alias);
	
	return type;
}

/* End of file. */

