/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/compiler.h>
#include <mom/c/libcast.h>

void cast_struct_add_slot(cast_type type, char *slot_name, cast_type slot_type)
{
	int i;

	assert(type->kind == CAST_TYPE_STRUCT);

	i = type->cast_type_u_u.struct_type.slots.slots_len++;
	type->cast_type_u_u.struct_type.slots.slots_val = (cast_struct_slot*)mustrealloc(
		type->cast_type_u_u.struct_type.slots.slots_val,
		sizeof(cast_struct_slot)*type->cast_type_u_u.struct_type.slots.slots_len);
	type->cast_type_u_u.struct_type.slots.slots_val[i].name = slot_name;
	type->cast_type_u_u.struct_type.slots.slots_val[i].type = slot_type;
}

