/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/compiler.h>
#include <mom/c/libcast.h>

void cast_union_add_case(cast_type type, char *case_name, cast_type case_type)
{
	int i;

	assert(type->kind == CAST_TYPE_UNION);

	i = type->cast_type_u_u.union_type.cases.cases_len++;
	type->cast_type_u_u.union_type.cases.cases_val = (cast_union_case*)mustrealloc(
		type->cast_type_u_u.union_type.cases.cases_val,
		sizeof(cast_union_case)*type->cast_type_u_u.union_type.cases.cases_len);
	type->cast_type_u_u.union_type.cases.cases_val[i].name = case_name;
	type->cast_type_u_u.union_type.cases.cases_val[i].type = case_type;
}

