/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/compiler.h>
#include <mom/c/libcast.h>

void cast_w_block(cast_block *block, int indent)
{
	int i;

	w_i_printf(indent, "{\n");

	cast_w_scope(&block->scope, indent+1);

	if ((block->scope.cast_scope_len > 0)
	    && (block->stmts.stmts_len > 0))
		w_putc('\n');

	for (i = 0; i < (signed int)block->stmts.stmts_len; i++)
	{
		assert(block->stmts.stmts_val[i]);
		if (block->stmts.stmts_val[i]->kind != CAST_STMT_NULL)
			cast_w_stmt(block->stmts.stmts_val[i], indent+1);
	}

	w_i_printf(indent, "}\n");
}

