#include <mom/cast.h>
#include <rpc/rpc.h>


bool_t
xdr_cast_type(xdrs, objp)
	XDR *xdrs;
	cast_type *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct cast_type_u), xdr_cast_type_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_expr(xdrs, objp)
	XDR *xdrs;
	cast_expr *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct cast_expr_u), xdr_cast_expr_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_stmt(xdrs, objp)
	XDR *xdrs;
	cast_stmt *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct cast_stmt_u), xdr_cast_stmt_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_init(xdrs, objp)
	XDR *xdrs;
	cast_init *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct cast_init_u), xdr_cast_init_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_scope(xdrs, objp)
	XDR *xdrs;
	cast_scope *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->cast_scope_val, (u_int *)&objp->cast_scope_len, ~0, sizeof(struct cast_def), xdr_cast_def)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_field(xdrs, objp)
	XDR *xdrs;
	cast_field *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_cast_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_primitive_kind(xdrs, objp)
	XDR *xdrs;
	cast_primitive_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_alias(xdrs, objp)
	XDR *xdrs;
	alias *objp;
{
	if (!xdr_string(xdrs, objp, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_primitive_modifier(xdrs, objp)
	XDR *xdrs;
	cast_primitive_modifier *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_primitive_type(xdrs, objp)
	XDR *xdrs;
	cast_primitive_type *objp;
{
	if (!xdr_cast_primitive_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	if (!xdr_cast_primitive_modifier(xdrs, &objp->mod)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->name, sizeof(alias), xdr_alias)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_struct_slot(xdrs, objp)
	XDR *xdrs;
	cast_struct_slot *objp;
{
	if (!xdr_cast_field(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_enum_field(xdrs, objp)
	XDR *xdrs;
	cast_enum_field *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_cast_expr(xdrs, &objp->val)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_enum_type(xdrs, objp)
	XDR *xdrs;
	cast_enum_type *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->slots.slots_val, (u_int *)&objp->slots.slots_len, ~0, sizeof(cast_enum_field), xdr_cast_enum_field)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_struct_type(xdrs, objp)
	XDR *xdrs;
	cast_struct_type *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->slots.slots_val, (u_int *)&objp->slots.slots_len, ~0, sizeof(cast_struct_slot), xdr_cast_struct_slot)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_array_type(xdrs, objp)
	XDR *xdrs;
	cast_array_type *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->length)) {
		return (FALSE);
	}
	if (!xdr_cast_type(xdrs, &objp->element_type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_union_case(xdrs, objp)
	XDR *xdrs;
	cast_union_case *objp;
{
	if (!xdr_cast_field(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_union_type(xdrs, objp)
	XDR *xdrs;
	cast_union_type *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(cast_union_case), xdr_cast_union_case)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_pointer_type(xdrs, objp)
	XDR *xdrs;
	cast_pointer_type *objp;
{
	if (!xdr_cast_type(xdrs, &objp->target)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_func_param(xdrs, objp)
	XDR *xdrs;
	cast_func_param *objp;
{
	if (!xdr_cast_field(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_func_type(xdrs, objp)
	XDR *xdrs;
	cast_func_type *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->params.params_val, (u_int *)&objp->params.params_len, ~0, sizeof(cast_func_param), xdr_cast_func_param)) {
		return (FALSE);
	}
	if (!xdr_cast_type(xdrs, &objp->return_type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_type_qualifier(xdrs, objp)
	XDR *xdrs;
	cast_type_qualifier *objp;
{
	if (!xdr_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_qualified_type(xdrs, objp)
	XDR *xdrs;
	cast_qualified_type *objp;
{
	if (!xdr_cast_type_qualifier(xdrs, &objp->qual)) {
		return (FALSE);
	}
	if (!xdr_cast_type(xdrs, &objp->actual)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_type_kind(xdrs, objp)
	XDR *xdrs;
	cast_type_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_type_u(xdrs, objp)
	XDR *xdrs;
	cast_type_u *objp;
{
	if (!xdr_cast_type_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case CAST_TYPE_NAME:
		if (!xdr_string(xdrs, &objp->cast_type_u_u.name, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_PRIMITIVE:
		if (!xdr_cast_primitive_type(xdrs, &objp->cast_type_u_u.primitive_type)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_STRUCT:
		if (!xdr_cast_struct_type(xdrs, &objp->cast_type_u_u.struct_type)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_UNION:
		if (!xdr_cast_union_type(xdrs, &objp->cast_type_u_u.union_type)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_POINTER:
		if (!xdr_cast_pointer_type(xdrs, &objp->cast_type_u_u.pointer_type)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_ARRAY:
		if (!xdr_cast_array_type(xdrs, &objp->cast_type_u_u.array_type)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_FUNCTION:
		if (!xdr_cast_func_type(xdrs, &objp->cast_type_u_u.func_type)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_ENUM:
		if (!xdr_cast_enum_type(xdrs, &objp->cast_type_u_u.enum_type)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_STRUCT_NAME:
		if (!xdr_string(xdrs, &objp->cast_type_u_u.struct_name, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_UNION_NAME:
		if (!xdr_string(xdrs, &objp->cast_type_u_u.union_name, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_ENUM_NAME:
		if (!xdr_string(xdrs, &objp->cast_type_u_u.enum_name, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_TYPE_VOID:
		break;
        case CAST_TYPE_FPAGE:
                break;
        case CAST_TYPE_L4STRING:
                break;
	case CAST_TYPE_QUALIFIED:
		if (!xdr_cast_qualified_type(xdrs, &objp->cast_type_u_u.qualified)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_lit_prim_u(xdrs, objp)
	XDR *xdrs;
	cast_lit_prim_u *objp;
{
	if (!xdr_cast_primitive_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case CAST_PRIM_CHAR:
		if (!xdr_char(xdrs, &objp->cast_lit_prim_u_u.c)) {
			return (FALSE);
		}
		break;
	case CAST_PRIM_INT:
		if (!xdr_long(xdrs, &objp->cast_lit_prim_u_u.i)) {
			return (FALSE);
		}
		break;
	case CAST_PRIM_FLOAT:
		if (!xdr_float(xdrs, &objp->cast_lit_prim_u_u.f)) {
			return (FALSE);
		}
		break;
	case CAST_PRIM_DOUBLE:
		if (!xdr_double(xdrs, &objp->cast_lit_prim_u_u.d)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_lit_prim(xdrs, objp)
	XDR *xdrs;
	cast_lit_prim *objp;
{
	if (!xdr_cast_primitive_modifier(xdrs, &objp->mod)) {
		return (FALSE);
	}
	if (!xdr_cast_lit_prim_u(xdrs, &objp->u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_expr_call(xdrs, objp)
	XDR *xdrs;
	cast_expr_call *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->func)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->params.params_val, (u_int *)&objp->params.params_len, ~0, sizeof(cast_expr), xdr_cast_expr)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_expr_sel(xdrs, objp)
	XDR *xdrs;
	cast_expr_sel *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->var)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->member, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_unary_op(xdrs, objp)
	XDR *xdrs;
	cast_unary_op *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_unary_expr(xdrs, objp)
	XDR *xdrs;
	cast_unary_expr *objp;
{
	if (!xdr_cast_unary_op(xdrs, &objp->op)) {
		return (FALSE);
	}
	if (!xdr_cast_expr(xdrs, &objp->expr)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_expr_cast(xdrs, objp)
	XDR *xdrs;
	cast_expr_cast *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->expr)) {
		return (FALSE);
	}
	if (!xdr_cast_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_binary_op(xdrs, objp)
	XDR *xdrs;
	cast_binary_op *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_binary_expr(xdrs, objp)
	XDR *xdrs;
	cast_binary_expr *objp;
{
	if (!xdr_cast_binary_op(xdrs, &objp->op)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->expr, 2, sizeof(cast_expr), xdr_cast_expr)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_cond_expr(xdrs, objp)
	XDR *xdrs;
	cast_cond_expr *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->test)) {
		return (FALSE);
	}
	if (!xdr_cast_expr(xdrs, &objp->true_expr)) {
		return (FALSE);
	}
	if (!xdr_cast_expr(xdrs, &objp->false_expr)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_expr_kind(xdrs, objp)
	XDR *xdrs;
	cast_expr_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_expr_u(xdrs, objp)
	XDR *xdrs;
	cast_expr_u *objp;
{
	if (!xdr_cast_expr_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case CAST_EXPR_NAME:
		if (!xdr_string(xdrs, &objp->cast_expr_u_u.name, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_LIT_PRIM:
		if (!xdr_cast_lit_prim(xdrs, &objp->cast_expr_u_u.lit_prim)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_LIT_STRING:
		if (!xdr_string(xdrs, &objp->cast_expr_u_u.lit_string, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_CALL:
		if (!xdr_cast_expr_call(xdrs, &objp->cast_expr_u_u.call)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_SEL:
		if (!xdr_cast_expr_sel(xdrs, &objp->cast_expr_u_u.sel)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_UNARY:
		if (!xdr_cast_unary_expr(xdrs, &objp->cast_expr_u_u.unary)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_CAST:
		if (!xdr_cast_expr_cast(xdrs, &objp->cast_expr_u_u.cast)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_SIZEOF_EXPR:
		if (!xdr_cast_expr(xdrs, &objp->cast_expr_u_u.sizeof_expr)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_SIZEOF_TYPE:
		if (!xdr_cast_type(xdrs, &objp->cast_expr_u_u.sizeof_type)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_BINARY:
		if (!xdr_cast_binary_expr(xdrs, &objp->cast_expr_u_u.binary)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_OP_ASSIGN:
		if (!xdr_cast_binary_expr(xdrs, &objp->cast_expr_u_u.op_assign)) {
			return (FALSE);
		}
		break;
	case CAST_EXPR_COND:
		if (!xdr_cast_cond_expr(xdrs, &objp->cast_expr_u_u.cond)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_block(xdrs, objp)
	XDR *xdrs;
	cast_block *objp;
{
	if (!xdr_cast_scope(xdrs, &objp->scope)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->stmts.stmts_val, (u_int *)&objp->stmts.stmts_len, ~0, sizeof(cast_stmt), xdr_cast_stmt)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_if(xdrs, objp)
	XDR *xdrs;
	cast_if *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->test)) {
		return (FALSE);
	}
	if (!xdr_cast_stmt(xdrs, &objp->true_stmt)) {
		return (FALSE);
	}
	if (!xdr_cast_stmt(xdrs, &objp->false_stmt)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_while(xdrs, objp)
	XDR *xdrs;
	cast_while *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->test)) {
		return (FALSE);
	}
	if (!xdr_cast_stmt(xdrs, &objp->stmt)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_for(xdrs, objp)
	XDR *xdrs;
	cast_for *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->init)) {
		return (FALSE);
	}
	if (!xdr_cast_expr(xdrs, &objp->test)) {
		return (FALSE);
	}
	if (!xdr_cast_expr(xdrs, &objp->iter)) {
		return (FALSE);
	}
	if (!xdr_cast_stmt(xdrs, &objp->stmt)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_switch(xdrs, objp)
	XDR *xdrs;
	cast_switch *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->test)) {
		return (FALSE);
	}
	if (!xdr_cast_stmt(xdrs, &objp->stmt)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_label(xdrs, objp)
	XDR *xdrs;
	cast_label *objp;
{
	if (!xdr_string(xdrs, &objp->label, ~0)) {
		return (FALSE);
	}
	if (!xdr_cast_stmt(xdrs, &objp->stmt)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_case(xdrs, objp)
	XDR *xdrs;
	cast_case *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->label)) {
		return (FALSE);
	}
	if (!xdr_cast_stmt(xdrs, &objp->stmt)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_stmt_kind(xdrs, objp)
	XDR *xdrs;
	cast_stmt_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_stmt_u(xdrs, objp)
	XDR *xdrs;
	cast_stmt_u *objp;
{
	if (!xdr_cast_stmt_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case CAST_STMT_EXPR:
		if (!xdr_cast_expr(xdrs, &objp->cast_stmt_u_u.expr)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_BLOCK:
		if (!xdr_cast_block(xdrs, &objp->cast_stmt_u_u.block)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_IF:
		if (!xdr_cast_if(xdrs, &objp->cast_stmt_u_u.s_if)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_WHILE:
		if (!xdr_cast_while(xdrs, &objp->cast_stmt_u_u.s_while)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_DO_WHILE:
		if (!xdr_cast_while(xdrs, &objp->cast_stmt_u_u.s_do_while)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_FOR:
		if (!xdr_cast_for(xdrs, &objp->cast_stmt_u_u.s_for)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_SWITCH:
		if (!xdr_cast_switch(xdrs, &objp->cast_stmt_u_u.s_switch)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_BREAK:
		break;
	case CAST_STMT_CONTINUE:
		break;
	case CAST_STMT_GOTO:
		if (!xdr_string(xdrs, &objp->cast_stmt_u_u.goto_label, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_LABEL:
		if (!xdr_cast_label(xdrs, &objp->cast_stmt_u_u.s_label)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_CASE:
		if (!xdr_cast_case(xdrs, &objp->cast_stmt_u_u.s_case)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_DEFAULT:
		if (!xdr_cast_stmt(xdrs, &objp->cast_stmt_u_u.default_stmt)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_RETURN:
		if (!xdr_cast_expr(xdrs, &objp->cast_stmt_u_u.return_expr)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_TEXT:
		if (!xdr_string(xdrs, &objp->cast_stmt_u_u.text, ~0)) {
			return (FALSE);
		}
		break;
	case CAST_STMT_NULL:
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_func_def(xdrs, objp)
	XDR *xdrs;
	cast_func_def *objp;
{
	if (!xdr_cast_func_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_cast_block(xdrs, &objp->block)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_init_kind(xdrs, objp)
	XDR *xdrs;
	cast_init_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_init_u(xdrs, objp)
	XDR *xdrs;
	cast_init_u *objp;
{
	if (!xdr_cast_init_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case CAST_INIT_EXPR:
		if (!xdr_cast_expr(xdrs, &objp->cast_init_u_u.expr)) {
			return (FALSE);
		}
		break;
	case CAST_INIT_AGGREGATE:
		if (!xdr_array(xdrs, (char **)&objp->cast_init_u_u.subs.subs_val, (u_int *)&objp->cast_init_u_u.subs.subs_len, ~0, sizeof(cast_init), xdr_cast_init)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_var_def(xdrs, objp)
	XDR *xdrs;
	cast_var_def *objp;
{
	if (!xdr_cast_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_cast_init(xdrs, &objp->init)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_include(xdrs, objp)
	XDR *xdrs;
	cast_include *objp;
{
	if (!xdr_string(xdrs, &objp->filename, ~0)) {
		return (FALSE);
	}
	if (!xdr_bool(xdrs, &objp->system_only)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_direct(xdrs, objp)
	XDR *xdrs;
	cast_direct *objp;
{
	if (!xdr_string(xdrs, &objp->code_string, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_storage_class(xdrs, objp)
	XDR *xdrs;
	cast_storage_class *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_def_kind(xdrs, objp)
	XDR *xdrs;
	cast_def_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_def_u(xdrs, objp)
	XDR *xdrs;
	cast_def_u *objp;
{
	if (!xdr_cast_def_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case CAST_TYPEDEF:
		if (!xdr_cast_type(xdrs, &objp->cast_def_u_u.typedef_type)) {
			return (FALSE);
		}
		break;
	case CAST_STRUCT:
		if (!xdr_cast_struct_type(xdrs, &objp->cast_def_u_u.struct_type)) {
			return (FALSE);
		}
		break;
	case CAST_UNION:
		if (!xdr_cast_union_type(xdrs, &objp->cast_def_u_u.union_type)) {
			return (FALSE);
		}
		break;
	case CAST_ENUM:
		if (!xdr_cast_enum_type(xdrs, &objp->cast_def_u_u.enum_type)) {
			return (FALSE);
		}
		break;
	case CAST_FUNC_DECL:
		if (!xdr_cast_func_type(xdrs, &objp->cast_def_u_u.func_type)) {
			return (FALSE);
		}
		break;
	case CAST_FUNC_DEF:
		if (!xdr_cast_func_def(xdrs, &objp->cast_def_u_u.func_def)) {
			return (FALSE);
		}
		break;
	case CAST_VAR_DECL:
		if (!xdr_cast_type(xdrs, &objp->cast_def_u_u.var_type)) {
			return (FALSE);
		}
		break;
	case CAST_VAR_DEF:
		if (!xdr_cast_var_def(xdrs, &objp->cast_def_u_u.var_def)) {
			return (FALSE);
		}
		break;
	case CAST_DEFINE:
		if (!xdr_cast_expr(xdrs, &objp->cast_def_u_u.define_as)) {
			return (FALSE);
		}
		break;
	case CAST_INCLUDE:
		if (!xdr_cast_include(xdrs, &objp->cast_def_u_u.include)) {
			return (FALSE);
		}
		break;
	case CAST_DIRECT_CODE:
		if (!xdr_cast_direct(xdrs, &objp->cast_def_u_u.direct)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_def(xdrs, objp)
	XDR *xdrs;
	cast_def *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_cast_storage_class(xdrs, &objp->sc)) {
		return (FALSE);
	}
	if (!xdr_cast_def_u(xdrs, &objp->u)) {
		return (FALSE);
	}
	if (!xdr_inclusion(xdrs, &objp->included)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_cast_1(xdrs, objp)
	XDR *xdrs;
	cast_1 *objp;
{
	if (!xdr_cast_scope(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}


