#include <mom/pres_c.h>
#include <rpc/rpc.h>


bool_t
xdr_cast_ref(xdrs, objp)
	XDR *xdrs;
	cast_ref *objp;
{
	if (!xdr_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline(xdrs, objp)
	XDR *xdrs;
	pres_c_inline *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct pres_c_inline_u), xdr_pres_c_inline_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct pres_c_mapping_u), xdr_pres_c_mapping_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_alloc_flags(xdrs, objp)
	XDR *xdrs;
	pres_c_alloc_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_allocation(xdrs, objp)
	XDR *xdrs;
	pres_c_allocation *objp;
{
	if (!xdr_pres_c_alloc_flags(xdrs, &objp->flags)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->allocator, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_index(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_index *objp;
{
	if (!xdr_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_atom(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_atom *objp;
{
	if (!xdr_pres_c_inline_index(xdrs, &objp->index)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->mapping)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_struct_slot(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_struct_slot *objp;
{
	if (!xdr_int(xdrs, &objp->mint_struct_slot_index)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->inl)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_struct(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_struct *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->slots.slots_val, (u_int *)&objp->slots.slots_len, ~0, sizeof(pres_c_inline_struct_slot), xdr_pres_c_inline_struct_slot)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_func_params_struct(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_func_params_struct *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->slots.slots_val, (u_int *)&objp->slots.slots_len, ~0, sizeof(pres_c_inline_struct_slot), xdr_pres_c_inline_struct_slot)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->return_slot, sizeof(pres_c_inline_struct_slot), xdr_pres_c_inline_struct_slot)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_struct_union_case(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_struct_union_case *objp;
{
	if (!xdr_int(xdrs, &objp->index)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->mapping)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_struct_union(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_struct_union *objp;
{
	if (!xdr_pres_c_inline_atom(xdrs, &objp->discrim)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline_index(xdrs, &objp->union_index)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(pres_c_inline_struct_union_case), xdr_pres_c_inline_struct_union_case)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->dfault, sizeof(pres_c_inline_struct_union_case), xdr_pres_c_inline_struct_union_case)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_void_union_case(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_void_union_case *objp;
{
	if (!xdr_cast_expr(xdrs, &objp->case_value)) {
		return (FALSE);
	}
	if (!xdr_cast_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->mapping)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_void_union(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_void_union *objp;
{
	if (!xdr_pres_c_inline_atom(xdrs, &objp->discrim)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline_index(xdrs, &objp->void_index)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(pres_c_inline_void_union_case), xdr_pres_c_inline_void_union_case)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->dfault, sizeof(pres_c_inline_void_union_case), xdr_pres_c_inline_void_union_case)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_expanded_union(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_expanded_union *objp;
{
	if (!xdr_pres_c_inline_atom(xdrs, &objp->discrim)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(pres_c_inline), xdr_pres_c_inline)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->dfault)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_collapsed_union(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_collapsed_union *objp;
{
	if (!xdr_mint_const(xdrs, &objp->discrim_val)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->selected_case)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_virtual_union_case(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_virtual_union_case *objp;
{
	if (!xdr_cast_type(xdrs, &objp->ctype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->map)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_virtual_union(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_virtual_union *objp;
{
	if (!xdr_pres_c_inline_virtual_union_case(xdrs, &objp->discrim)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(pres_c_inline_virtual_union_case), xdr_pres_c_inline_virtual_union_case)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->dfault, sizeof(pres_c_inline_virtual_union_case), xdr_pres_c_inline_virtual_union_case)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_typed(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_typed *objp;
{
	if (!xdr_pres_c_inline(xdrs, &objp->tag)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->inl)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_counted_array(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_counted_array *objp;
{
	if (!xdr_pres_c_inline(xdrs, &objp->len)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->max)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline_atom(xdrs, &objp->ptr)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->ptr_levels)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_terminated_array(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_terminated_array *objp;
{
	if (!xdr_int(xdrs, &objp->terminator)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->max)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline_atom(xdrs, &objp->ptr)) {
		return (FALSE);
	}
	if (!xdr_pres_c_allocation(xdrs, &objp->alloc)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_xlate(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_xlate *objp;
{
	if (!xdr_pres_c_inline(xdrs, &objp->sub)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline_index(xdrs, &objp->index)) {
		return (FALSE);
	}
	if (!xdr_cast_type(xdrs, &objp->internal_ctype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_alloc_flags(xdrs, &objp->alloc_flags)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->translator, ~0)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->destructor, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_assign(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_assign *objp;
{
	if (!xdr_pres_c_inline(xdrs, &objp->sub)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline_index(xdrs, &objp->index)) {
		return (FALSE);
	}
	if (!xdr_cast_expr(xdrs, &objp->value)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_cond(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_cond *objp;
{
	if (!xdr_pres_c_inline_index(xdrs, &objp->index)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->true_inl)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->false_inl)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_message_attribute_kind(xdrs, objp)
	XDR *xdrs;
	pres_c_message_attribute_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_message_attribute(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_message_attribute *objp;
{
	if (!xdr_pres_c_message_attribute_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_kind(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_inline_u(xdrs, objp)
	XDR *xdrs;
	pres_c_inline_u *objp;
{
	if (!xdr_pres_c_inline_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case PRES_C_INLINE_ATOM:
		if (!xdr_pres_c_inline_atom(xdrs, &objp->pres_c_inline_u_u.atom)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_STRUCT:
		if (!xdr_pres_c_inline_struct(xdrs, &objp->pres_c_inline_u_u.struct_i)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_FUNC_PARAMS_STRUCT:
		if (!xdr_pres_c_inline_func_params_struct(xdrs, &objp->pres_c_inline_u_u.func_params_i)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_STRUCT_UNION:
		if (!xdr_pres_c_inline_struct_union(xdrs, &objp->pres_c_inline_u_u.struct_union)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_EXPANDED_UNION:
		if (!xdr_pres_c_inline_expanded_union(xdrs, &objp->pres_c_inline_u_u.expanded_union)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_VOID_UNION:
		if (!xdr_pres_c_inline_void_union(xdrs, &objp->pres_c_inline_u_u.void_union)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_COLLAPSED_UNION:
		if (!xdr_pres_c_inline_collapsed_union(xdrs, &objp->pres_c_inline_u_u.collapsed_union)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_VIRTUAL_UNION:
		if (!xdr_pres_c_inline_virtual_union(xdrs, &objp->pres_c_inline_u_u.virtual_union)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_TYPED:
		if (!xdr_pres_c_inline_typed(xdrs, &objp->pres_c_inline_u_u.typed)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_COUNTED_ARRAY:
		if (!xdr_pres_c_inline_counted_array(xdrs, &objp->pres_c_inline_u_u.counted_array)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_TERMINATED_ARRAY:
		if (!xdr_pres_c_inline_terminated_array(xdrs, &objp->pres_c_inline_u_u.terminated_array)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_THROWAWAY:
		break;
	case PRES_C_INLINE_XLATE:
		if (!xdr_pres_c_inline_xlate(xdrs, &objp->pres_c_inline_u_u.xlate)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_ASSIGN:
		if (!xdr_pres_c_inline_assign(xdrs, &objp->pres_c_inline_u_u.assign)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_COND:
		if (!xdr_pres_c_inline_cond(xdrs, &objp->pres_c_inline_u_u.cond)) {
			return (FALSE);
		}
		break;
	case PRES_C_INLINE_MESSAGE_ATTRIBUTE:
		if (!xdr_pres_c_inline_message_attribute(xdrs, &objp->pres_c_inline_u_u.msg_attr)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_stub(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_stub *objp;
{
	if (!xdr_int(xdrs, &objp->mapping_stub_index)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_direction(xdrs, objp)
	XDR *xdrs;
	pres_c_direction *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_direction(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_direction *objp;
{
	if (!xdr_pres_c_direction(xdrs, &objp->dir)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->mapping)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_pointer(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_pointer *objp;
{
	if (!xdr_pres_c_allocation(xdrs, &objp->alloc)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->target)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_optional_pointer(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_optional_pointer *objp;
{
	if (!xdr_pres_c_allocation(xdrs, &objp->alloc)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->target)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_struct(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_struct *objp;
{
	if (!xdr_pres_c_inline(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_fixed_array(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_fixed_array *objp;
{
	if (!xdr_pres_c_allocation(xdrs, &objp->alloc)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->length)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->element_mapping)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_terminated_array(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_terminated_array *objp;
{
	if (!xdr_pres_c_allocation(xdrs, &objp->alloc)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->terminator)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->max)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->element_mapping)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_flat_union(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_flat_union *objp;
{
	if (!xdr_pres_c_mapping(xdrs, &objp->discrim)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(pres_c_mapping), xdr_pres_c_mapping)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->dfault)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_special(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_special *objp;
{
	if (!xdr_string(xdrs, &objp->marshaler_name, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_xlate(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_xlate *objp;
{
	if (!xdr_cast_type(xdrs, &objp->internal_ctype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->internal_mapping)) {
		return (FALSE);
	}
	if (!xdr_pres_c_alloc_flags(xdrs, &objp->alloc_flags)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->translator, ~0)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->destructor, ~0)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_reference_kind(xdrs, objp)
	XDR *xdrs;
	pres_c_reference_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_reference(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_reference *objp;
{
	if (!xdr_pres_c_reference_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->ref_count)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_sid_kind(xdrs, objp)
	XDR *xdrs;
	pres_c_sid_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_sid(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_sid *objp;
{
	if (!xdr_pres_c_sid_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_message_attribute(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_message_attribute *objp;
{
	if (!xdr_pres_c_message_attribute_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_argument(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_argument *objp;
{
	if (!xdr_string(xdrs, &objp->arg_name, ~0)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->map)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_kind(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_mapping_u(xdrs, objp)
	XDR *xdrs;
	pres_c_mapping_u *objp;
{
	if (!xdr_pres_c_mapping_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case PRES_C_MAPPING_DIRECT:
		break;
	case PRES_C_MAPPING_STUB:
		if (!xdr_pres_c_mapping_stub(xdrs, &objp->pres_c_mapping_u_u.mapping_stub)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_POINTER:
		if (!xdr_pres_c_mapping_pointer(xdrs, &objp->pres_c_mapping_u_u.pointer)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_FIXED_ARRAY:
		if (!xdr_pres_c_mapping_fixed_array(xdrs, &objp->pres_c_mapping_u_u.fixed_array)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_TERMINATED_ARRAY:
		if (!xdr_pres_c_mapping_terminated_array(xdrs, &objp->pres_c_mapping_u_u.terminated_array)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_STRUCT:
		if (!xdr_pres_c_mapping_struct(xdrs, &objp->pres_c_mapping_u_u.struct_i)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_FLAT_UNION:
		if (!xdr_pres_c_mapping_flat_union(xdrs, &objp->pres_c_mapping_u_u.flat_union)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_SPECIAL:
		if (!xdr_pres_c_mapping_special(xdrs, &objp->pres_c_mapping_u_u.special)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_XLATE:
		if (!xdr_pres_c_mapping_xlate(xdrs, &objp->pres_c_mapping_u_u.xlate)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_REFERENCE:
		if (!xdr_pres_c_mapping_reference(xdrs, &objp->pres_c_mapping_u_u.ref)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_TYPE_TAG:
		break;
	case PRES_C_MAPPING_OPTIONAL_POINTER:
		if (!xdr_pres_c_mapping_optional_pointer(xdrs, &objp->pres_c_mapping_u_u.optional_pointer)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_IGNORE:
		break;
	case PRES_C_MAPPING_SYSTEM_EXCEPTION:
		break;
	case PRES_C_MAPPING_DIRECTION:
		if (!xdr_pres_c_mapping_direction(xdrs, &objp->pres_c_mapping_u_u.direction)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_SID:
		if (!xdr_pres_c_mapping_sid(xdrs, &objp->pres_c_mapping_u_u.sid)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_ARGUMENT:
		if (!xdr_pres_c_mapping_argument(xdrs, &objp->pres_c_mapping_u_u.argument)) {
			return (FALSE);
		}
		break;
	case PRES_C_MAPPING_MESSAGE_ATTRIBUTE:
		if (!xdr_pres_c_mapping_message_attribute(xdrs, &objp->pres_c_mapping_u_u.message_attribute)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_marshal_stub(xdrs, objp)
	XDR *xdrs;
	pres_c_marshal_stub *objp;
{
	if (!xdr_cast_ref(xdrs, &objp->c_func)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->i)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->target_i)) {
		return (FALSE);
	}
	if (!xdr_pres_c_mapping(xdrs, &objp->seethru_map)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_stub_op_flags(xdrs, objp)
	XDR *xdrs;
	pres_c_stub_op_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_client_stub(xdrs, objp)
	XDR *xdrs;
	pres_c_client_stub *objp;
{
	if (!xdr_cast_ref(xdrs, &objp->c_func)) {
		return (FALSE);
	}
	if (!xdr_pres_c_stub_op_flags(xdrs, &objp->op_flags)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->request_itype)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->reply_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->request_i)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->reply_i)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->target_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->target_i)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->client_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->client_i)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->error_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->error_i)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_server_func(xdrs, objp)
	XDR *xdrs;
	pres_c_server_func *objp;
{
	if (!xdr_cast_ref(xdrs, &objp->c_func)) {
		return (FALSE);
	}
	if (!xdr_pres_c_stub_op_flags(xdrs, &objp->op_flags)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->request_i)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->reply_i)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->target_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->target_i)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->client_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->client_i)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->error_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->error_i)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_server_skel(xdrs, objp)
	XDR *xdrs;
	pres_c_server_skel *objp;
{
	if (!xdr_cast_ref(xdrs, &objp->c_def)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->request_itype)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->reply_itype)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->funcs.funcs_val, (u_int *)&objp->funcs.funcs_len, ~0, sizeof(pres_c_server_func), xdr_pres_c_server_func)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_msg_stub(xdrs, objp)
	XDR *xdrs;
	pres_c_msg_stub *objp;
{
	if (!xdr_cast_ref(xdrs, &objp->c_func)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->msg_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->msg_i)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->target_itype)) {
		return (FALSE);
	}
	if (!xdr_pres_c_inline(xdrs, &objp->target_i)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_send_stub(xdrs, objp)
	XDR *xdrs;
	pres_c_send_stub *objp;
{
	if (!xdr_pres_c_msg_stub(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_reply_stub(xdrs, objp)
	XDR *xdrs;
	pres_c_reply_stub *objp;
{
	if (!xdr_pres_c_msg_stub(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_stub_kind(xdrs, objp)
	XDR *xdrs;
	pres_c_stub_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_stub(xdrs, objp)
	XDR *xdrs;
	pres_c_stub *objp;
{
	if (!xdr_pres_c_stub_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case PRES_C_MARSHAL_STUB:
		if (!xdr_pres_c_marshal_stub(xdrs, &objp->pres_c_stub_u.mstub)) {
			return (FALSE);
		}
		break;
	case PRES_C_UNMARSHAL_STUB:
		if (!xdr_pres_c_marshal_stub(xdrs, &objp->pres_c_stub_u.ustub)) {
			return (FALSE);
		}
		break;
	case PRES_C_CLIENT_STUB:
		if (!xdr_pres_c_client_stub(xdrs, &objp->pres_c_stub_u.cstub)) {
			return (FALSE);
		}
		break;
	case PRES_C_SERVER_SKEL:
		if (!xdr_pres_c_server_skel(xdrs, &objp->pres_c_stub_u.sskel)) {
			return (FALSE);
		}
		break;
	case PRES_C_SEND_STUB:
		if (!xdr_pres_c_send_stub(xdrs, &objp->pres_c_stub_u.send_stub)) {
			return (FALSE);
		}
		break;
	case PRES_C_REPLY_STUB:
		if (!xdr_pres_c_reply_stub(xdrs, &objp->pres_c_stub_u.reply_stub)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_pres_c_1(xdrs, objp)
	XDR *xdrs;
	pres_c_1 *objp;
{
	if (!xdr_mint_1(xdrs, &objp->mint)) {
	    printf("xdr_mint_1\n");
		return (FALSE);
	}
	if (!xdr_cast_1(xdrs, &objp->cast)) {
	    printf("xdr_cast_1\n");
		return (FALSE);
	}
	if (!xdr_aoi(xdrs, &objp->a)) {
	    printf("xdr_aoi\n");
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->stubs.stubs_val, (u_int *)&objp->stubs.stubs_len, ~0, sizeof(pres_c_stub), xdr_pres_c_stub)) {
		printf("xdr_array\n");
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->pres_context, ~0)) {
		printf("xdr_string\n");
		return (FALSE);
	}
	return (TRUE);
}


