/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <string.h>
#include <mom/compiler.h>
#include <mom/c/libcast.h>

#include "fluke.h"

void w_server_skel(pres_c_1 *pres, int stub_idx)
{
	assert(pres);
	
	pres_c_stub *stub = &pres->stubs.stubs_val[stub_idx];
	assert(stub->kind == PRES_C_SERVER_SKEL);
	pres_c_server_skel *sskel = &stub->pres_c_stub_u.sskel;
	assert(sskel->c_def >= 0);
	assert(sskel->c_def < (signed int)pres->cast.cast_scope_len);
	cast_def *cdef = &pres->cast.cast_scope_val[sskel->c_def];
	
	mint_ref      simple_request_itype;
	pres_c_inline simple_request_inline;
	
	fluke_mu_state must(pres,
			    (MUST_DECODE | MUST_ALLOCATE),
			    RPCM_TRUSTED, "server");
	
	emergency_return_value = cast_new_expr_name("return DISPATCH_ACK_SEND");
	
	/*
	 * Initialize `simple_request_itype' to the "whole" MINT request type,
	 * so that in case we have no server-side functions, we'll still point
	 * to *some* valid MINT type!
	 */
	simple_request_itype = sskel->request_itype;
	
	/* Build an initial array of `decode_switch_case's for the top level of
	   decoding. */
	decode_switch_case dcase[sskel->funcs.funcs_len];
	for (unsigned int i = 0; i < sskel->funcs.funcs_len; i++) {
		/* Strip away the ``collapsed union'' goo that encodes IDL and
		   interface information.  We don't need that information for
		   Fluke IPC because it is manifest in the object references.
		   
		   The astute reader will note that the function call below
		   only takes care of half of the problem --- what about the
		   reply?  The IDL and interface codes are removed from the
		   reply by a Fluke IPC version of `mu_server_func_reply()'. */
		remove_idl_and_interface_ids(
			pres,
			sskel->request_itype,
			sskel->funcs.funcs_val[i].request_i,
			&simple_request_itype,
			&simple_request_inline);
		
		dcase[i].inl         = simple_request_inline;
		dcase[i].server_func = &sskel->funcs.funcs_val[i];
		dcase[i].server_skel = sskel;
	}

	/* Use `mu_decode_switch' to produce the code to discriminate between
	   the possible set of messages, unmarshal the corresponding data,
	   invoke the server work functions, and marshal the replies.  Yes,
	   from this high up, everything looks simple! */
	must.mu_decode_switch(dcase,
			      sskel->funcs.funcs_len,
			      simple_request_itype);
	
	/* Output the server dispatch function. */
	w_printf("mom_dispatch_action_t ");
	w_printf(("%s(void *_dispatch_obj, "
		  "mom_dispatch_data_t *_dispatch_data)\n"),
		 cdef->name);
	w_printf("{\n");
	if (must.c_block) {
		w_i_printf(1, "flick_marshal_stream_struct _stream_struct;\n");
		w_i_printf(1, "const flick_marshal_stream_t _stream ");
		w_printf("= &_stream_struct;\n\n");
		w_i_printf(1, "flick_fluke_server_start_decode();\n");
		/*
		 * The matching `end_decode' macro is output by `mu_state::
		 * mu_server_func'.
		 */
		cast_w_stmt(must.c_block, 1);
	} else
		warn("Empty server skeleton!");
	
	cast_w_stmt(
		cast_new_return(
			cast_new_expr_name(
				FLUKE_SERVER_NO_REPLY_VALUE)),
		1);
	w_printf("}\n");
}

/* End of file. */

