/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>

#include <mom/compiler.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "iiop.h"

void w_client_stub(pres_c_1 *pres, int stub_idx)
{
	assert(pres);
	
	pres_c_stub *stub = &pres->stubs.stubs_val[stub_idx];
	pres_c_client_stub *cstub = &stub->pres_c_stub_u.cstub;
	cast_def *cfunc = &pres->cast.cast_scope_val[cstub->c_func];
	cast_func_type *cfunct = &cfunc->u.cast_def_u_u.func_type;
	
	mint_ref            operation_itype;
	pres_c_inline       operation_inline;
	
	int assumptions = RPCM_TRUSTED; /* XXX */
	char *emergency_return_string;
	
	if (cfunct->return_type->kind != CAST_TYPE_VOID)
		emergency_return_string = "return _return";
	else
		emergency_return_string = "return";
	emergency_return_value = cast_new_expr_name(emergency_return_string);
	
	/* Build the parameter marshal/unmarshal code. */
	iiop_mu_state must_in(pres,
			      (MUST_ENCODE | MUST_DEALLOCATE), assumptions,
			      "client");
	remove_idl_and_interface_ids(pres,
				     cstub->request_itype, cstub->request_i,
				     &operation_itype, &operation_inline);
	must_in.mu_func_params(cstub->c_func,
			       operation_itype, operation_inline);
	must_in.mu_end();
	
	iiop_mu_state must_out(pres,
			       (MUST_DECODE | MUST_ALLOCATE), assumptions,
			       "client", IIOP_NO_SWAP);
	remove_idl_and_interface_ids(pres,
				     cstub->reply_itype, cstub->reply_i,
				     &operation_itype, &operation_inline);
	remove_operation_id(pres,
			    operation_itype, operation_inline,
			    &operation_itype, &operation_inline);
	must_out.mu_func_params(cstub->c_func,
				operation_itype, operation_inline);
	must_out.mu_end();

	iiop_mu_state must_swap(pres,
				(MUST_DECODE | MUST_ALLOCATE), assumptions,
				"client", IIOP_SWAP);
	must_swap.mu_func_params(cstub->c_func,
				 operation_itype, operation_inline);
	must_swap.mu_end();
	
	/* Build the target object marshaling code. */
	iiop_target_mu_state must_target(pres,
					 (MUST_ENCODE | MUST_DEALLOCATE), 0,
					 "client");
	must_target.mu_func_params(cstub->c_func, cstub->target_itype,
				   cstub->target_i);
	must_target.mu_end();

	/* Start writing the client stub. */
	cast_w_func_type(cfunc->name, cfunct, 0);
	w_printf("\n{\n");
	w_i_printf(1, "FLICK_BUFFER *_stream;\n");
	
	if (cfunct->return_type->kind != CAST_TYPE_VOID) {
		/*
		 * Initialize `_return' to be zero.  This eliminates compiler
		 * warnings about returning uninitialized data.
		 */
		cast_expr init_expr
			= cast_new_expr_assign_to_zero(
				cast_new_expr_name("_return"),
				cfunct->return_type,
				&(pres->cast)
				);
		
		w_indent(1);
		cast_w_type("_return", cfunct->return_type, 1);
		w_printf(";\n");
		
		w_printf("\n");
		cast_w_stmt(cast_new_stmt_expr(init_expr), 1);
	} else
		w_printf("\n");
	
#if 0
	/*
	 * XXX --- #if 0'ed out because this code assumes that 0 is a null
	 * object reference.  That's for the presentation generator to decide!
	 * We should do this: `if (flick_<pres>_object_is_nil(...)) ...'.
	 */
	/* Guard against null target object references. */
	cast_w_stmt(
		cast_new_if(
			cast_new_binary_expr(CAST_BINARY_EQ,
					     cast_new_expr_name("_obj"),
					     cast_new_expr_lit_int(0, 0)
				),
			must_in.make_error("FLICK_ERROR_INVALID_TARGET"),
			0),
		1);
#endif
	
	w_i_printf(1,
		   "flick_%s_client_start_encode();\n",
		   must_in.get_be_name());
	cast_w_stmt(must_target.c_block, 1);
	
	/* Output the general marshaling code. */
	cast_w_stmt(must_in.c_block, 1);
	w_i_printf(1,
		   "flick_%s_client_end_encode();\n",
		   must_in.get_be_name());
	
	/*
	 * If the operation is oneway, only use send_request, and end the
	 * function.
	 */
	w_i_printf(1,
		   "flick_%s_client_set_response_expected(%d);\n",
		   must_in.get_be_name(),
		   ((cstub->op_flags & PRES_C_STUB_OP_FLAG_ONEWAY) ? 0 : 1));
	
	if (cstub->op_flags & PRES_C_STUB_OP_FLAG_ONEWAY) {
		w_i_printf(1,
			   "if (!flick_client_send_request(_obj, _obj->boa->in))"
			   "\n");
		w_i_printf(2,
			   "flick_%s_decode_client_error"
			   "(%s, FLICK_ERROR_COMMUNICATION, %s, %s);\n",
			   must_in.pres->pres_context,
			   emergency_return_string,
			   must_in.get_encode_name(),
			   must_in.get_be_name());
		w_printf("}\n\n");
		return;
	}
	
	w_i_printf(1,
		   "if (!flick_client_send_request(_obj, _obj->boa->in) "
		   "||\n");
	w_i_printf(1,
		   "    !flick_client_get_reply(_obj, _obj->boa->out))"
		   "\n");
	w_i_printf(2,
		   "flick_%s_decode_client_error"
		   "(%s, FLICK_ERROR_COMMUNICATION, %s, %s);\n",
		   must_in.pres->pres_context,
		   emergency_return_string,
		   must_in.get_encode_name(),
		   must_in.get_be_name());
	w_i_printf(1,
		   "flick_%s_client_start_decode();\n",
		   must_in.get_be_name());
	w_i_printf(1,
		   "if (flick_cdr_swap()) {\n");
	
	/* Output the general unmarshaling swap code. */
	cast_w_stmt(must_swap.c_block, 2);
	
	w_i_printf(1, "} else {\n");
	
	/* Output the general unmarshaling code. */
	cast_w_stmt(must_out.c_block, 2);
	
	w_i_printf(1, "}\n");
	
	w_i_printf(1,
		   "flick_%s_client_end_decode();\n",
		   must_in.get_be_name());
	
	if (cfunct->return_type->kind != CAST_TYPE_VOID)
		w_i_printf(1, "return _return;\n");
	w_printf("}\n\n");
}

/* End of file. */

