/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#ifndef _iiop_h

#include <mom/c/pbe_mem.hh>
#include <mom/c/pbe_target.hh>
#include <mom/c/pbe_client.hh>
#define IIOP_NO_SWAP 0
#define IIOP_SWAP 1

struct iiop_mu_state : public mem_mu_state
{
	// This is whether or not the code should byteswap
	int should_swap;
  
	iiop_mu_state(pres_c_1 *_pres, 
		      mu_state_op _op, 
		      int _assumptions, 
		      char *which, 
		      int swap = IIOP_NO_SWAP);
  
	iiop_mu_state(const iiop_mu_state &must);
	mu_state *clone();
	mu_state *another(mu_state_op op);

	virtual char *get_be_name();
	virtual char *get_encode_name();
	virtual int get_most_packable()
	{
		return 4;
	}
	
	virtual void get_prim_params(mint_ref itype, int *size, int *align_bits, char **macro_name);

	virtual void mu_server_func_reply(pres_c_server_func *sfunc, pres_c_server_skel *sskel);
	
	virtual target_mu_state *mu_make_target_mu_state(pres_c_1 *pres,
							 mu_state_op op,
							 int assumptions,
							 char *which);
	virtual client_mu_state *mu_make_client_mu_state(pres_c_1 *pres,
							 mu_state_op op,
							 int assumptions,
							 char *which);
	
	/* This returns nil, if it's not a fixed size, or a sizeof call otherwise */
	virtual cast_expr mu_get_sizeof(mint_ref itype,
					cast_type ctype,
					pres_c_mapping map,
					int *size,
					int *align_bits);
  
	/* This returns a #if (0), #else (1), or #endif (2) for bit-translation checking */
	virtual cast_stmt mu_bit_translation_necessary(int);
	virtual void mu_prefix_params();
	
	virtual void mu_mapping_stub_call(cast_expr expr, cast_type ctype,
					  mint_ref itype, pres_c_mapping map);
	
	/* This is used for passing object references other than the self reference */
	virtual void mu_mapping_reference(cast_expr expr, cast_type ctype, mint_ref itype,
					  pres_c_mapping_reference *rmap);
};

struct iiop_target_mu_state : public target_mu_state
{
	iiop_target_mu_state(pres_c_1 *_pres, mu_state_op _op, int _assumptions, char *which);
	iiop_target_mu_state(const iiop_target_mu_state &must);
	virtual mu_state *clone(); 
	virtual char *get_be_name();
	virtual char *get_encode_name();
};

struct iiop_client_mu_state : public client_mu_state
{
	iiop_client_mu_state(pres_c_1 *_pres, mu_state_op _op, int _assumptions, char *which);
	iiop_client_mu_state(const iiop_client_mu_state &must);
	virtual mu_state *clone(); 
	virtual char *get_be_name();
	virtual char *get_encode_name();
};

#endif _iiop_h

/* End of file. */

