/*
 * Copyright (c) 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <mom/c/libcast.h>
#include "iiop.h"

void iiop_mu_state::mu_prefix_params() 
{
	/*
	 * In IIOP, a `Principal' pseudo object comes between the operation
	 * discriminator and the operation parameters in the request header.
	 * (See Section 12.4.1 of the CORBA 2.0 specification.)  This pseudo
	 * object is encoded as an octet sequence (Section 12.3.4) and has no
	 * meaning for us (yet).
	 */
	
	if ((op & MUST_ENCODE) &&
	    !strcmp("client", get_which_stub())) {
		/*
		 * Encode a zero-length octet sequence in the request.
		 */
		cast_stmt comment = cast_new_stmt(CAST_STMT_TEXT);
		
		comment->cast_stmt_u_u.text
			= flick_asprintf("/* Encode the requesting "
					 "`Principal' pseudo object "
					 "(security ID). */");
		add_stmt(comment);
		
		cast_expr cexpr_zero
			= cast_new_expr_lit_int(0, CAST_MOD_UNSIGNED);
		cast_type ctype_ulong
			= cast_new_prim_type(CAST_PRIM_INT, CAST_MOD_UNSIGNED);
		
		mu_mapping_simple(cexpr_zero,
				  ctype_ulong,
				  pres->mint.standard_refs.unsigned32_ref);
	}
	
	if ((op & MUST_DECODE) &&
	    !strcmp("server", get_which_stub())) {
		/*
		 * Decode an arbitrary `Principal' octet sequence on the server
		 * side.  Although Flick-generated clients never encode non-
		 * zero-length `Principal's, we might be talking to a client
		 * generated by some other compiler.
		 */
		cast_type ctype_ulong
			= cast_new_prim_type(CAST_PRIM_INT, CAST_MOD_UNSIGNED);
		cast_expr cexpr_principal_len
			= add_temp_var("principal_len", ctype_ulong);
		
		cast_stmt comment = cast_new_stmt(CAST_STMT_TEXT);
		
		cast_expr *principal_glob_size_expr;
		cast_expr *principal_chunk_size_expr;
		
		/*****/
		
		comment->cast_stmt_u_u.text =
			flick_asprintf("/* Skip over the requesting "
				       "`Principal' pseudo object "
				       "(security ID). */");
		add_stmt(comment);
		
		mu_mapping_simple(cexpr_principal_len,
				  ctype_ulong,
				  pres->mint.standard_refs.unsigned32_ref);
		/*
		 * We have to break the current glob; the Principal sequence
		 * can be arbitrarily long.
		 */
		break_glob();
		
		new_glob();
		new_chunk();
		/*
		 * Save the size expressions; we need to mangle them after
		 * `end_chunk/end_glob' and insert a reference to the length of
		 * the `Principal' sequence.
		 */
		principal_glob_size_expr = glob_size_expr;
		principal_chunk_size_expr = chunk_size_expr;
		end_chunk();
		end_glob();
		
		/* Fix the glob and chunk size expressions. */
		(*principal_glob_size_expr) = cexpr_principal_len;
		(*principal_chunk_size_expr) = cexpr_principal_len;
		
		/*
		 * Fix our memory alignment state.  The `mu_state' probably
		 * thinks that we are 4-byte aligned at this point (following
		 * a 4-byte aligned integer and a zero-byte chunk), but we
		 * really aren't.  We're only 1-byte aligned after skipping
		 * over the `Principal' octet sequence.
		 */
		max_msg_size = MAXUINT_MAX;
		align_bits = 0;
		align_ofs = 0;
	}
	
	mem_mu_state::mu_prefix_params();
}

/* End of file. */

