/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>
#include <mom/c/libpres_c.h>
#include "iiop.h"

iiop_mu_state::iiop_mu_state(pres_c_1 *pres, mu_state_op op, int assumptions, char *which, int swap)
:	mem_mu_state(pres, op, assumptions, 2, 0, 8192/*XXX*/, which)
{
	should_swap = swap;
}

iiop_mu_state::iiop_mu_state(const iiop_mu_state &must)
:	mem_mu_state(must)
{
	should_swap = must.should_swap;
}

mu_state *iiop_mu_state::another(mu_state_op op)
{
	return new iiop_mu_state(pres, op, assumptions, get_which_stub(), should_swap);
}

mu_state *iiop_mu_state::clone()
{
	return new iiop_mu_state(*this);
}

void iiop_mu_state::get_prim_params(mint_ref itype, int *size, int *align_bits, char **macro_name)
{
	mem_mu_state::get_prim_params(itype, size, align_bits, macro_name);
	
        mint_def *def = &(pres->mint.defs.defs_val[itype]);
	
	if ((def->kind == MINT_INTEGER)
            && (array_def != 0)) {
                /*
                 * We're processing an array length, and we always pad these
                 * out to four bytes.
                 */
                int bits, is_signed;
                
                assert(*size <= 4);
                *size = 4;
                *align_bits = 2;
                
                /* We must recompute the macro name, too. */
                mint_get_int_size(&pres->mint, itype, &bits, &is_signed);
                *macro_name = flick_asprintf("flick_%s_%s_%s%d",
                                             get_encode_name(),
                                             get_buf_name(),
                                             (is_signed ?
                                              "signed" : "unsigned"),
                                             ((*size) * 8));
        }
}

iiop_target_mu_state::iiop_target_mu_state(pres_c_1 *pres, mu_state_op op, int assumptions, char *which)
	: target_mu_state(pres, op, assumptions, which)
{
}

iiop_target_mu_state::iiop_target_mu_state(const iiop_target_mu_state &must)
	: target_mu_state(must)
{
}

mu_state *iiop_target_mu_state::clone()
{
	return new iiop_target_mu_state(*this);
}

char *iiop_target_mu_state::get_encode_name() 
{
	return "cdr";
}

char *iiop_target_mu_state::get_be_name()
{
    return "iiop";
}

iiop_client_mu_state::iiop_client_mu_state(pres_c_1 *pres, mu_state_op op, int assumptions, char *which)
	: client_mu_state(pres, op, assumptions, which)
{
}

iiop_client_mu_state::iiop_client_mu_state(const iiop_client_mu_state &must)
	: client_mu_state(must)
{
}

mu_state *iiop_client_mu_state::clone()
{
	return new iiop_client_mu_state(*this);
}

char *iiop_client_mu_state::get_encode_name() 
{
	return "cdr";
}

char *iiop_client_mu_state::get_be_name()
{
    return "iiop";
}

char *iiop_mu_state::get_encode_name() 
{
	if (should_swap == IIOP_NO_SWAP || now_packing || !(op & MUST_DECODE))
		return "cdr";
	else
		return "cdr_swap";
}

char *iiop_mu_state::get_be_name()
{
   return "iiop";
}

void
w_header_includes(pres_c_1 * /*p*/)
{
  w_printf("#include <flick/link/iiop.h>\n");
  w_printf("#include <flick/encode/cdr.h>\n");
}

/* End of file. */
