/*
 * Copyright (c) 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>

#include "l4.h"


static void my_mint_get_int_size(mint_1 *mint, mint_ref itype,
				 int *out_bits, int *out_is_signed)
{
	mint_def *def;
	mint_integer_def *i;
	int bits, is_signed;

	assert(itype >= 0); assert(itype < (signed int) mint->defs.defs_len);
	def = &(mint->defs.defs_val[itype]);
	assert(def->kind == MINT_INTEGER);
	i = &(def->mint_def_u.integer_def);

	if (i->min >= 0) {
		is_signed = 0;
		if (i->min + i->range <= 1)
		        bits = 1;
		else if (i->min + i->range <= 3)
		        bits = 2;
		else if (i->min + i->range <= 15)
		        bits = 4;
		else if (i->min + i->range <= 255)
			bits = 8;
		else if (i->min + i->range <= 65535)
			bits = 16;
		else
			/* XXX --- What about *really* big ints? */
			bits = 32;
	} else {
		is_signed = 1;
		if ((i->min >= -2) && (i->min + i->range <= 1))
			bits = 2;
		else if ((i->min >= -8) && (i->min + i->range <= 7))
			bits = 4;
		else if ((i->min >= -128) && (i->min + i->range <= 127))
			bits = 8;
		else if ((i->min >= -32768) && (i->min + i->range <= 32767))
			bits = 16;
		else
			/* XXX --- What about *really* big ints? */
			bits = 32;
	}
	
	*out_bits = bits;
	*out_is_signed = is_signed;
}


void l4_mu_state::get_prim_params(mint_ref itype, int *size,
				     int *align_bits, char **macro_name)
{
	mint_def *def = &(pres->mint.defs.defs_val[itype]);


	/* By default, do the `mem_mu_state' thing. */
	mem_mu_state::get_prim_params(itype, size, align_bits, macro_name);

	/*
	 * Now handle our special cases.
	 */
	
	if (def->kind == MINT_INTERFACE) {
		/*
		 * Because port references are marshaled in a buffer separate
		 * from the normal data marshal buffer, ports are effectively
		 * zero-byte objects.
		 *
		 * However, with every port reference, we send along a 32-bit
		 * flags word to support such things as MOM notifications.
		 * So, instead of being zero-byte objects, ports appear to be
		 * 4-byte objects.
		 */
		*size = 4;
		*align_bits = 2;
		bitpos = 0;
		
		/*
		 * Further, the runtime needs to do different things for client
		 * and server so that MOM can do notifications.  So we must
		 * manufacture a special macro name, too, based on the value of
		 * `get_which_stub'.
		 */
		*macro_name = flick_asprintf("flick_%s_%s_%s_%s%d",
					     get_encode_name(),
					     get_which_stub(),
					     get_buf_name(),
					     "port",
					     ((*size) * 8));
	}

#if 0
	// we do that twice - but who cares...
	if (def->kind == MINT_INTEGER)
	{
		int bits, is_signed;
		char *basic_type_name;

		// urx - necessary for type-size
		// don't want to change central stuff!!!
		my_mint_get_int_size(&pres->mint, itype, &bits, &is_signed);
		printf("my_mint_get_int_size bits: %d\n", bits);

		// arrays are ### ALWAYS ### 4 bytes per entry
		if (array_def || bits >= 32) {
		    bitpos = 0;
		    return;
		}

		basic_type_name = is_signed ? "signed" : "unsigned";

		// do we have an overflow ???
		if (bitpos + bits > 32)
		    bitpos = 0;

		// if we are the first entry we are 4 bytes long
		// and aligned, otherwise we are 0-entries
		if (bitpos == 0)
		{
		    *size = 4;
		    *align_bits = 2;
		}
		else {
		    *size = 0;
		    *align_bits = 0;
		}
		
		// count, how many bits are already written...
		bitpos += bits;

		*macro_name = flick_asprintf("flick_%s_%s_%s%d",
					     get_encode_name(),
					     get_buf_name(),
					     basic_type_name,
					     bits);
	}
#endif
}

/* End of file. */

