/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>
#include <mom/c/libpres_c.h>

#include "l4.h"


/*****************************************************************************/

l4_mu_state::l4_mu_state(pres_c_1 *pres, mu_state_op op, int assumptions, char *which)
	: mem_mu_state(pres, op, assumptions, 3, 0, 8192, which)
{
	/* Nothing else to do. */
}

l4_mu_state::l4_mu_state(const l4_mu_state &must)
	: mem_mu_state(must)
{
	/* Nothing else to do. */
}

mu_state *l4_mu_state::another(mu_state_op op)
{
	return new l4_mu_state(pres, op, assumptions, which_stub);
}

mu_state *l4_mu_state::clone()
{
	return new l4_mu_state(*this);
}

char *l4_mu_state::get_be_name()
{
	return "l4";
}

char *l4_mu_state::get_encode_name()
{
	return "l4";
}

/*****************************************************************************/

l4_target_mu_state::l4_target_mu_state(pres_c_1 *pres, mu_state_op op,
					     int assumptions, char *which)
	: target_mu_state(pres, op, assumptions, which)
{
	/* Nothing else to do. */
}

l4_target_mu_state::l4_target_mu_state(const l4_target_mu_state &must)
	: target_mu_state(must)
{
	/* Nothing else to do. */
}

mu_state *l4_target_mu_state::clone()
{
	return new l4_target_mu_state(*this);
}

/* NOTE THAT THIS STUFF NEEDS TO BE CHANGED IN THE INCLUDES, TOO!!!! */

char *l4_target_mu_state::get_be_name()
{
    return "l4";
}

char *l4_target_mu_state::get_encode_name()
{
    return "l4";
}

/*****************************************************************************/

l4_client_mu_state::l4_client_mu_state(pres_c_1 *pres, mu_state_op op,
					     int assumptions, char *which)
	: client_mu_state(pres, op, assumptions, which)
{
	/* Nothing else to do. */
}

l4_client_mu_state::l4_client_mu_state(const l4_client_mu_state &must)
	: client_mu_state(must)
{
	/* Nothing else to do. */
}

mu_state *l4_client_mu_state::clone()
{
	return new l4_client_mu_state(*this);
}

/* NOTE THAT THIS STUFF NEEDS TO BE CHANGED IN THE INCLUDES, TOO!!!! */

char *l4_client_mu_state::get_be_name()
{
    return "l4";
}

char *l4_client_mu_state::get_encode_name()
{
    return "l4";
}

/*****************************************************************************/

void w_header_includes(pres_c_1 * /*p*/)
{
	/* These should reflect the be & encode names from above */
	w_printf("#include <flick/link/l4.h>\n");
	w_printf("#include <flick/encode/l4.h>\n");
}

/* `remove_idl_and_interface_ids' strips away the ``collapsed union'' stuff
   that encodes IDL and interface information.  L4 client and server stubs
   don't need to encode this information because it is manifest in L4
   object references.
   
   Similarly, `remove_operation_id' strips away the ``collapsed union'' stuff
   that encodes an operation identifier.  This information isn't required in
   reply messages.
   */

void remove_idl_and_interface_ids(
	pres_c_1 *pres,
	mint_ref in_itype, pres_c_inline in_inline,
	mint_ref *out_itype, pres_c_inline *out_inline)
{
	*out_itype  = in_itype;
	*out_inline = in_inline;
	
	descend_collapsed_union(pres, out_itype, out_inline);
	descend_collapsed_union(pres, out_itype, out_inline);
}

void remove_operation_id(
	pres_c_1 *pres,
	mint_ref in_itype, pres_c_inline in_inline,
	mint_ref *out_itype, pres_c_inline *out_inline)
{
	*out_itype  = in_itype;
	*out_inline = in_inline;
	
	descend_collapsed_union(pres, out_itype, out_inline);
}

/* End of file. */

