/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>

#include "l4.h"

void l4_mu_state::mu_server_func_target(pres_c_server_func *sfunc)
{
	l4_target_mu_state *must_target =
		(l4_target_mu_state *)
		mu_make_target_mu_state(pres, op, assumptions, "server");
	
	/*
	 * Create a CAST expression refering to the function's target object
	 * parameter by ``(un)marshaling'' that parameter.  Our special
	 * `l4_target_mu_state' puts the CAST in its `target_cast_expr'
	 * slot; see the file `l4_target_mu_mapping_reference.cc'.
	 */
	must_target->mu_func_params(sfunc->c_func, sfunc->target_itype,
				    sfunc->target_i);
	must_target->mu_end();

	if (op & MUST_DECODE) {
		/*
		 * When decoding, output an assignment expression that copies
		 * the server dispatch function's object reference into the
		 * parameter that will be passed to the server work function.
		 * Note that the parameter is a local variable and has already
		 * been declared --- see `mu_state::mu_server_func'.
		 */
		add_stmt(cast_new_stmt_expr(
			cast_new_expr_assign(
				must_target->target_cast_expr,
				cast_new_expr_cast(
					/*
					 * XXX --- Need to un-hardwire
					 * the name of the obj ref!
					 */
					cast_new_expr_name("request"),
					must_target->target_cast_type
					))));
	}
}

/* End of file. */

