/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>
#include <mom/c/libcast.h>
#include <mom/c/pbe_mem.hh>

/* This function should return either
   a null expression, if the type is NOT fixed,
   or a sizeof expression for the size of the data structure.
   Specifically, this is used from within mu_array
   to see if the memory layout of
   the data structure is identical to
   the buffer layout.
   
   NOTE:  This does NOT require that
   the bit-wise data layout is correct,
   just that the alignment & padding is OK.
   See mu_bit_translation_necessary for stuff regarding bit translation.
   */

cast_expr mem_mu_state::mu_get_sizeof(mint_ref itype,
				      cast_type /*ctype*/,
				      pres_c_mapping map,
				      int *size,
				      int *align_bits)
{
	cast_expr res = 0;
	*size = *align_bits = -1;

	/* if we don't have a direct mapping, we can't easily
           determine the size of this type */
	if (map->kind != PRES_C_MAPPING_DIRECT)
		return 0;
	
	mint_def *def;
	assert(itype >= 0);
	assert(itype < (signed int) pres->mint.defs.defs_len);
	def = &pres->mint.defs.defs_val[itype];
	
	switch (def->kind) {
	case MINT_INTEGER:
	case MINT_SCALAR:
	case MINT_FLOAT:
	case MINT_CHAR:
		char *name;
		get_prim_params(itype, size, align_bits, &name);
		break;
		
	case MINT_BOOLEAN:
		/* this is the common case, so override this if you
		   want something different */
		*size = 4;
		*align_bits = 2;
		break;

	case MINT_VOID:
		*size = *align_bits = 0;
		break;
		
	default:
		break;
	}

	if (*size>=0) {
		res = cast_new_expr_lit_int(*size, 0);
	}
	return res;
}

/* End of file. */

