/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>
#include <mom/c/libcast.h>
#include <mom/c/pbe.hh>

/* Return statements (generally macros)
   that specify whether or not we need to do bit translation
   I.E. in SUN, this would return #if LITTLE_ENDIAN/#else/#endif
   
   The parameter specifies whether to output the if, else or endif
   (0, 1, 2 respectively)
   */

static char *if_text = "#if 1 /* is bit translation necessary? - should be specialized */";
static char *else_text = "#else /* bit translation */";
static char *endif_text = "#endif /* bit translation */";

cast_stmt mu_state::mu_bit_translation_necessary(int which)
{
  cast_stmt macro = cast_new_stmt(CAST_STMT_TEXT);
  switch (which) {
  case 0: // #if LITTLE_ENDIAN
    macro->cast_stmt_u_u.text = if_text;
    break;
  case 1:
    macro->cast_stmt_u_u.text = else_text;
    break;
  case 2:
    macro->cast_stmt_u_u.text = endif_text;
    break;
  default:
    panic("Invalid value passed to mu_bit_translation_necessary\n");
  }
  return macro;
}

