/*
 * Copyright (c) 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/c/pbe.hh>

void mu_state::mu_inline_message_attribute(
	inline_state * /* ist */,
	mint_ref /* itype */,
	pres_c_inline inl)
{
	char *msg;
	pres_c_inline_message_attribute *msg_attr
		= &(inl->pres_c_inline_u_u.msg_attr);
	
	switch (msg_attr->kind) {
	case PRES_C_MESSAGE_ATTRIBUTE_FLAGS:
		msg = "message flags";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_TIMEOUT:
		msg = "message timeouts";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_SEQUENCE_RECEIVED:
		msg = "message sequencing";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_CLIENT_REFERENCE:
		msg = "client references";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_SERVERCOPY:
		msg = "server copy information";
		break;
		
	default:
		panic("In `mu_state::mu_inline_message_attribute', "
		      "unknown attribute %d.",
		      msg_attr->kind);
		break;
	}
	warn("This backend doesn't support %s.", msg);
}

/* End of file. */

