/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>
#include <mom/c/pbe.hh>

cast_stmt mu_state::make_error(char *err_val) 
{
	cast_expr call = cast_new_expr_call(
		cast_new_expr_name(
			flick_asprintf("flick_%s_%s_%s_error",
				       pres->pres_context,
				       get_buf_name(),
				       which_stub)
				),
			4);
	call->cast_expr_u_u.call.params.params_val[0] = emergency_return_value;
	call->cast_expr_u_u.call.params.params_val[1] =
		cast_new_expr_name(err_val);
	call->cast_expr_u_u.call.params.params_val[2] =
		cast_new_expr_name(get_encode_name());
	call->cast_expr_u_u.call.params.params_val[3] =
		cast_new_expr_name(get_be_name());
	
	return cast_new_stmt_expr(call);
}

	
