/*
 * Copyright (c) 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/c/pbe.hh>

void mu_state::mu_mapping_message_attribute(
	cast_expr /*expr*/,
	cast_type /*ctype*/,
	mint_ref /*itype*/,
	pres_c_mapping_message_attribute *attr_map)
{
	char *msg;
	
	switch (attr_map->kind) {
	case PRES_C_MESSAGE_ATTRIBUTE_FLAGS:
		msg = "message flags";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_TIMEOUT:
		msg = "message timeouts";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_SEQUENCE_RECEIVED:
		msg = "message sequencing";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_CLIENT_REFERENCE:
		msg = "client references";
		break;
		
	case PRES_C_MESSAGE_ATTRIBUTE_SERVERCOPY:
		msg = "server copy information";
		break;
		
	default:
		panic("In `mu_state::mu_inline_message_attribute', "
		      "unknown attribute %d.",
		      attr_map->kind);
		break;
	}
	warn("This backend doesn't support %s.", msg);
}

/* End of file. */

