/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/c/libcast.h>
#include <mom/c/pbe.hh>

/* This routine handles simple pointer indirection -
   pointers in the presented type that map to nothing on actual interface.
   It calls the appropriate routines to handle pointer allocation/deallocation semantics,
   but other than that just adds a CAST_UNARY_DEREF node to the accessor expression being built
   and descends to the next level in the itype and mapping trees
   without going anywhere on the itype side.
*/
void mu_state::mu_mapping_pointer(cast_expr pexpr, cast_type ctype, mint_ref itype,
				  pres_c_mapping_pointer *pmap)
{
	/*
	 * If the CAST type of our pointer is a named type, locate the actual
	 * pointer type.  (Note: The MIG FE/PG makes these kinds of direct
	 * associations between named C types and MAPPING_POINTER
	 * nodes.  Other PG's generally indirect through a MAPPING_STUB, and
	 * the named type is derefenced to a pointer type there.)
	 */
	ctype = cast_find_typedef_type(&(pres->cast), ctype);
	if (!ctype)
		panic("In `mu_state::mu_mapping_pointer', "
		      "can't locate `typedef' for a named type.");

	assert(ctype->kind == CAST_TYPE_POINTER);
	cast_type to_ctype = ctype->cast_type_u_u.pointer_type.target;
	
	mu_array(pexpr, ctype, &pmap->alloc,
		 to_ctype, itype, pmap->target,
		 cast_new_expr_lit_int(1, 0),
		 0 /* indicates this isn't an array */,
		 1, 1 /* min = max = 1 */);
}

